/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interop.multiplexing.byorb;

import java.util.Properties;
import java.util.logging.Level;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import scs.core.ComponentContext;
import scs.core.ComponentId;
import tecgraf.openbus.Connection;
import tecgraf.openbus.InvalidLoginCallback;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.PrivateKey;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.OpenBusPrivateKey;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.interop.multiplexing.byorb.HelloServant;
import tecgraf.openbus.interop.simple.HelloHelper;
import tecgraf.openbus.interop.util.Utils;

public class Server {
    public static void main(String[] args) {
        try {
            Properties props = Utils.readPropertyFile((String)"/test.properties");
            String host = props.getProperty("bus.host.name");
            int port = Integer.valueOf(props.getProperty("bus.host.port"));
            String entity = "interop_multiplexing_java_server";
            String privateKeyFile = "admin/InteropMultiplexing.key";
            Utils.setLogLevel((Level)Level.parse(props.getProperty("log.level", "OFF")));
            OpenBusPrivateKey privateKey = OpenBusPrivateKey.createPrivateKeyFromFile((String)privateKeyFile);
            ORB orb1 = ORBInitializer.initORB((String[])args);
            new Utils.ORBRunThread(orb1).start();
            Utils.ShutdownThread shutdown1 = new Utils.ShutdownThread(orb1);
            Runtime.getRuntime().addShutdownHook((Thread)shutdown1);
            ORB orb2 = ORBInitializer.initORB((String[])args);
            new Utils.ORBRunThread(orb2).start();
            Utils.ShutdownThread shutdown2 = new Utils.ShutdownThread(orb2);
            Runtime.getRuntime().addShutdownHook((Thread)shutdown2);
            OpenBusContext context1 = (OpenBusContext)orb1.resolve_initial_references("OpenBusContext");
            Connection conn1 = context1.createConnection(host, port);
            context1.setDefaultConnection(conn1);
            OpenBusContext context2 = (OpenBusContext)orb2.resolve_initial_references("OpenBusContext");
            Connection conn2 = context2.createConnection(host, port);
            context2.setDefaultConnection(conn2);
            conn1.onInvalidLoginCallback((InvalidLoginCallback)new Callback(conn1, "conn1"));
            conn2.onInvalidLoginCallback((InvalidLoginCallback)new Callback(conn2, "conn2"));
            POA poa1 = POAHelper.narrow((Object)orb1.resolve_initial_references("RootPOA"));
            poa1.the_POAManager().activate();
            ComponentId id = new ComponentId("Hello", 1, 0, 0, "java");
            ComponentContext component1 = new ComponentContext(orb1, poa1, id);
            component1.addFacet("Hello", HelloHelper.id(), (Servant)new HelloServant(context1));
            POA poa2 = POAHelper.narrow((Object)orb2.resolve_initial_references("RootPOA"));
            poa2.the_POAManager().activate();
            ComponentContext component2 = new ComponentContext(orb2, poa2, id);
            component2.addFacet("Hello", HelloHelper.id(), (Servant)new HelloServant(context2));
            conn1.loginByCertificate(entity, (PrivateKey)privateKey);
            conn2.loginByCertificate(entity, (PrivateKey)privateKey);
            shutdown1.addConnetion(conn1);
            shutdown2.addConnetion(conn2);
            ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Interoperability Tests")};
            context1.getOfferRegistry().registerService(component1.getIComponent(), serviceProperties);
            context2.getOfferRegistry().registerService(component1.getIComponent(), serviceProperties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Callback
    implements InvalidLoginCallback {
        private String name;
        private Connection conn;

        public Callback(Connection conn, String name) {
            this.name = name;
            this.conn = conn;
        }

        public void invalidLogin(Connection conn, LoginInfo login) {
            System.out.println("login terminated: " + this.name);
        }
    }
}

