/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2011, Open Source Geospatial Foundation (OSGeo)
 *    (C) 2004-2005, Open Geospatial Consortium Inc.
 *    
 *    All Rights Reserved. http://www.opengis.org/legal/
 */

/**
 * {@linkplain org.opengis.metadata.citation.Citation} and
 * {@linkplain org.opengis.metadata.citation.ResponsibleParty responsible party} information.
 * The following is adapted from
 * <A HREF="http://www.opengis.org/docs/01-111.pdf">OpenGIS&reg; Metadata (Topic 11)</A> specification.
 *
 * <P ALIGN="justify">This package of datatypes provides a standardized method
 * ({@linkplain org.opengis.metadata.citation.Citation citation}) for citing a resource
 * (dataset, feature, source, publication, etc.), as well as information about the
 * {@linkplain org.opengis.metadata.citation.ResponsibleParty party responsible} for a resource.
 * The {@linkplain org.opengis.metadata.citation.ResponsibleParty responsible party} contains the
 * identity of person(s), and/or position, and/or organization(s) associated with the resource. The
 * location ({@linkplain org.opengis.metadata.citation.Address address}) of the responsible person
 * or organization is also defined here.</P>
 *
 * @version <A HREF="http://www.opengeospatial.org/standards/as#01-111">ISO 19115</A>
 * @since   GeoAPI 1.0
 */
package org.opengis.metadata.citation;
