/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.ext;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.ext.SNMPTrapAppender;
import org.apache.log4j.ext.SnmpTrapSenderFacade;
import org.apache.log4j.helpers.LogLog;

public class NetSnmpCommandLineTrapSender
implements SnmpTrapSenderFacade {
    private static final String NET_SNMP_CMD_LINE_TRAP_SENDER_DIAGNOSTIC_PROPERTY = "log4j.ext.snmpTrapAppender.netSnmp.diagnostic";
    private static final String NET_SNMP_BIN_PATH_PROPERTY = "log4j.ext.snmpTrapAppender.netSnmp.binPath";
    private static final String NET_SNMP_MIBS_PATH_PROPERTY = "log4j.ext.snmpTrapAppender.netSnmp.mibsPath";
    private static final String NET_SNMP_BIN_PATH_DEFAULT = "/usr/local/bin/";
    private static final String NET_SNMP_MIBS_PATH_DEFAULT = "/usr/local/share/mibs";
    private String managementHost = "127.0.0.1";
    private String enterpriseOID = "1.3.6.1.2.1.1.2.0";
    private String localIPAddress = "127.0.0.1";
    private int genericTrapType = 0;
    private int specificTrapType = 6;
    private String communityString = "public";
    private long sysUpTime = 0L;
    private boolean isInitialized = false;
    private List bindVariables;

    public void initialize(SNMPTrapAppender appender) {
        this.managementHost = appender.getManagementHost();
        this.enterpriseOID = appender.getEnterpriseOID();
        this.localIPAddress = appender.getLocalIPAddress();
        this.communityString = appender.getCommunityString();
        this.sysUpTime = appender.getSysUpTime();
        this.genericTrapType = appender.getGenericTrapType();
        this.specificTrapType = appender.getSpecificTrapType();
        this.bindVariables = new ArrayList();
        this.isInitialized = true;
    }

    public void addTrapMessageVariable(String applicationTrapOIDValue, String value) {
        if (!this.isInitialized) {
            LogLog.error((String)"The initialize() method must be called before calling addTrapMessageVariable()");
            return;
        }
        this.bindVariables.add(new BindVariable(applicationTrapOIDValue, value));
    }

    public void sendTrap() {
        String binPath = System.getProperty(NET_SNMP_BIN_PATH_PROPERTY, NET_SNMP_BIN_PATH_DEFAULT);
        String mibsPath = System.getProperty(NET_SNMP_MIBS_PATH_PROPERTY, NET_SNMP_MIBS_PATH_DEFAULT);
        boolean diagnosticFlag = Boolean.getBoolean(NET_SNMP_CMD_LINE_TRAP_SENDER_DIAGNOSTIC_PROPERTY);
        if (diagnosticFlag) {
            LogLog.error((String)binPath);
            LogLog.error((String)mibsPath);
        }
        boolean index = false;
        String[] paramsX = this.sizeParameterArray();
        try {
            paramsX[0] = binPath + "snmptrap";
            this.fillParamsArray(paramsX, 0, mibsPath);
            if (diagnosticFlag) {
                LogLog.error((String)("Command line array contains: " + Arrays.asList(paramsX)));
            }
            Process einProcess = Runtime.getRuntime().exec(paramsX, null, new File(binPath));
            NetSnmpCommandLineTrapSender.handleProcessStream(new BufferedReader(new InputStreamReader(einProcess.getInputStream())), diagnosticFlag);
            NetSnmpCommandLineTrapSender.handleProcessStream(new BufferedReader(new InputStreamReader(einProcess.getErrorStream())), diagnosticFlag);
            int rc = einProcess.waitFor();
            if (0 != rc) {
                LogLog.error((String)"Error executing snmptrap!");
            }
        }
        catch (IOException e) {
            LogLog.error((String)"Error executing snmptrap!", (Throwable)e);
        }
        catch (InterruptedException e) {
            LogLog.error((String)"Error executing snmptrap!", (Throwable)e);
        }
    }

    private String[] sizeParameterArray() {
        int mandatoryParameterCount = 9;
        int variableParameterCount = 3 * this.bindVariables.size();
        return new String[9 + variableParameterCount];
    }

    private static void handleProcessStream(BufferedReader bufferedInputStreamReader, boolean diagnosticFlag) throws IOException, InterruptedException {
        int i = 0;
        while (i < 99) {
            if (bufferedInputStreamReader.ready()) break;
            Thread.sleep(100L);
            ++i;
        }
        while (bufferedInputStreamReader.ready()) {
            if (diagnosticFlag) {
                LogLog.error((String)bufferedInputStreamReader.readLine());
                continue;
            }
            bufferedInputStreamReader.readLine();
        }
        bufferedInputStreamReader.close();
    }

    private void fillParamsArray(String[] paramsX, int index, String mibsPath) {
        paramsX[++index] = "-M " + mibsPath;
        paramsX[++index] = this.managementHost;
        paramsX[++index] = this.communityString;
        paramsX[++index] = "." + this.enterpriseOID;
        paramsX[++index] = this.localIPAddress;
        paramsX[++index] = Integer.toString(this.genericTrapType);
        paramsX[++index] = Integer.toString(this.specificTrapType);
        paramsX[++index] = Long.toString(this.sysUpTime);
        Iterator varsIt = this.bindVariables.iterator();
        while (varsIt.hasNext()) {
            BindVariable tmpVar = (BindVariable)varsIt.next();
            paramsX[++index] = "." + tmpVar.getOid();
            paramsX[++index] = "s";
            paramsX[++index] = "\"" + tmpVar.getValue() + "\"";
        }
    }

    private static class BindVariable {
        private final String oid;
        private final String value;

        public BindVariable(String oidValue, String variableValue) {
            this.oid = oidValue;
            this.value = variableValue;
        }

        public String getOid() {
            return this.oid;
        }

        public String getValue() {
            return this.value;
        }
    }
}

