/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.cache;

import csbase.client.util.IFilter;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class CommandsFilter
implements IFilter<CommandInfo> {
    private Collection<CommandStatus> allowedStatuses;

    public CommandsFilter() {
        this(true, CommandStatus.values());
    }

    public CommandsFilter(CommandStatus ... statuses) {
        this(true, statuses);
    }

    public CommandsFilter(boolean in, CommandStatus ... statuses) {
        if (statuses == null || statuses.length == 0) {
            throw new IllegalArgumentException("Array de status de comando vazio ou nulo.");
        }
        HashSet<CommandStatus> allowedStatusesHashSet = new HashSet<CommandStatus>();
        if (in) {
            CommandStatus[] commandStatusArray = statuses;
            int n = statuses.length;
            int n2 = 0;
            while (n2 < n) {
                CommandStatus aStatus = commandStatusArray[n2];
                allowedStatusesHashSet.add(aStatus);
                ++n2;
            }
        } else {
            CommandStatus aStatus;
            CommandStatus[] commandStatusArray = CommandStatus.values();
            int n = commandStatusArray.length;
            int n3 = 0;
            while (n3 < n) {
                aStatus = commandStatusArray[n3];
                allowedStatusesHashSet.add(aStatus);
                ++n3;
            }
            commandStatusArray = statuses;
            n = statuses.length;
            n3 = 0;
            while (n3 < n) {
                aStatus = commandStatusArray[n3];
                allowedStatusesHashSet.remove(aStatus);
                ++n3;
            }
        }
        this.allowedStatuses = Collections.unmodifiableCollection(allowedStatusesHashSet);
    }

    public final Collection<CommandStatus> getAllowedStatus() {
        return this.allowedStatuses;
    }

    @Override
    public final boolean accept(CommandInfo cmd) {
        return this.allowedStatuses.contains(cmd.getStatus()) && this.acceptCommand(cmd);
    }

    protected boolean acceptCommand(CommandInfo cmd) {
        return true;
    }
}

