/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.cache.events;

import csbase.client.algorithms.commands.cache.CommandsFilter;
import csbase.client.algorithms.commands.cache.events.CacheUpdatedEvent;
import csbase.client.util.event.EventListener;
import csbase.logic.CommandInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractCacheUpdatedEventListener
implements EventListener<CacheUpdatedEvent> {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private CommandsFilter filter;

    public AbstractCacheUpdatedEventListener(CommandsFilter filter) {
        this.setFilter(filter);
    }

    public void setFilter(CommandsFilter filter) {
        this.lock.writeLock().lock();
        try {
            this.filter = filter;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public CommandsFilter getFilter() {
        this.lock.readLock().lock();
        try {
            CommandsFilter commandsFilter = this.filter;
            return commandsFilter;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public final void eventFired(CacheUpdatedEvent event) {
        if (CacheUpdatedEvent.Type.exception == event.getType()) {
            this.eventInterrupted(event.getException(), event.getExceptionDescription());
        } else {
            ArrayList<CommandInfo> commands;
            this.lock.readLock().lock();
            try {
                if (this.filter == null) {
                    return;
                }
                commands = new ArrayList<CommandInfo>();
                for (CommandInfo aCommand : event.getCommands()) {
                    if (!this.filter.accept(aCommand)) continue;
                    commands.add(aCommand);
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            this.eventFired((Collection<CommandInfo>)commands);
        }
    }

    @Override
    public abstract void eventFired(Collection<CommandInfo> var1);

    protected void eventInterrupted(Exception exception, String description) {
    }
}

