/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ComponentProperties;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.SimpleParameterView;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.resourcehelpers.ApplicationUtils;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.tasks.GetChildFromNameTask;
import csbase.client.project.tasks.GetFileTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.gui.GUIUtils;

public abstract class FileParameterView
extends SimpleParameterView<FileParameterValue> {
    @Deprecated
    protected FileParameterView(Window window, FileParameter parameter) {
        this(parameter, ParameterView.Mode.CONFIGURATION);
    }

    protected FileParameterView(FileParameter parameter, ParameterView.Mode mode) {
        super(parameter, mode, new Object[0]);
        this.updateViewContents();
        this.updateCapabilityView();
        this.updateVisibilyView();
    }

    @Override
    public FileParameter getParameter() {
        return (FileParameter)super.getParameter();
    }

    protected abstract FileParameterValue askForFile();

    @Override
    protected JComponent createConfigurationComponent(Object ... componentArgs) {
        return new FileConfigurationParameter();
    }

    @Override
    protected JComponent createReportComponent(Object ... componentArgs) {
        return new FileReportParameter();
    }

    @Override
    protected void setEnabled(boolean isEnabled) {
        this.getComponent().setEnabled(isEnabled);
    }

    @Override
    protected void updateVisibilyView() {
        boolean isVisible;
        boolean bl = isVisible = this.getParameter().isVisible() && !this.getParameter().hasLink() && this.getParameter().usesPipe() != FileParameterPipeAcceptance.ALWAYS;
        if (this.isVisible() != isVisible) {
            this.setVisible(isVisible);
            this.fireVisibilityWasChanged();
        }
    }

    @Override
    protected void updateViewContents() {
        ((IFileParameterComponent)((Object)this.getComponent())).updateViewContents();
    }

    @Override
    public boolean fillVerticalSpace() {
        return false;
    }

    private final class FileConfigurationParameter
    extends JPanel
    implements IFileParameterComponent {
        private JTextField textField;
        private JButton browseButton;

        FileConfigurationParameter() {
            this.setLayout(new GridBagLayout());
            this.browseButton = GUIUtils.createImageButton((Icon)ApplicationImages.ICON_BROWSEFILE_16);
            this.browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    FileParameterValue file = FileParameterView.this.askForFile();
                    if (file != null) {
                        FileParameterView.this.getParameter().setValue((Object)file);
                    }
                }
            });
            this.browseButton.setToolTipText(FileParameterView.this.getParameter().getDescription());
            this.textField = new JTextField();
            this.textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    FileConfigurationParameter.this.updateModel();
                }
            });
            this.textField.setToolTipText(FileParameterView.this.getParameter().getDescription());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.fill = 2;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.insets = new Insets(2, 2, 2, 2);
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            this.add((Component)this.textField, constraints);
            constraints.fill = 0;
            ++constraints.gridx;
            constraints.weightx = 0.0;
            this.add((Component)this.browseButton, constraints);
        }

        @Override
        public void updateViewContents() {
            FileParameterValue file = (FileParameterValue)FileParameterView.this.getParameter().getValue();
            if (file == null) {
                this.textField.setText("");
            } else {
                this.textField.setText(file.toString());
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.textField.setEnabled(isEnabled);
            this.browseButton.setEnabled(isEnabled);
        }

        private void updateModel() {
            String text = this.textField.getText();
            if (text.length() == 0) {
                FileParameterView.this.getParameter().setValue(null);
            } else {
                ClientProjectFile rootProjectFile;
                if (text.equals("/")) {
                    text = ".";
                } else if (text.startsWith("/")) {
                    text = text.substring(1);
                }
                String[] path = FileUtils.splitPath((String)text, (String)"/");
                CommonClientProject project = DesktopFrame.getInstance().getProject();
                ClientProjectFile clientProjectFile = rootProjectFile = project.getRoot();
                String type = FileParameterView.this.getParameter().getFileType();
                String[] stringArray = path;
                int n = path.length;
                int n2 = 0;
                while (n2 < n) {
                    String component = stringArray[n2];
                    if (clientProjectFile == null) break;
                    clientProjectFile = GetChildFromNameTask.runTask(clientProjectFile, component);
                    ++n2;
                }
                if (clientProjectFile != null) {
                    type = clientProjectFile.isDirectory() ? "DIRECTORY_TYPE" : clientProjectFile.getType();
                } else if (FileParameterView.this.getParameter().getMode() == FileParameterMode.DIRECTORY) {
                    type = "DIRECTORY_TYPE";
                }
                FileParameterValue file = new FileParameterValue(text, type);
                FileParameterView.this.getParameter().setValue((Object)file);
            }
        }
    }

    private final class FileReportParameter
    extends JPanel
    implements IFileParameterComponent {
        private JTextField textField;

        FileReportParameter() {
            this.setLayout(new GridBagLayout());
            this.textField = new JTextField();
            this.textField.setToolTipText(FileParameterView.this.getParameter().getDescription());
            ComponentProperties.setProperties(this.textField, ParameterView.Mode.REPORT, true);
            this.textField.setEditable(false);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.fill = 2;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.insets = new Insets(2, 2, 2, 2);
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            this.add((Component)this.textField, constraints);
            JButton button = this.createShowButton(this.textField);
            if (button != null) {
                constraints.fill = 0;
                ++constraints.gridx;
                constraints.weightx = 0.0;
                this.add((Component)button, constraints);
            }
            this.updateViewContents();
        }

        private JButton createShowButton(JTextField field) {
            final FileParameterValue value = (FileParameterValue)FileParameterView.this.getParameter().getValue();
            if (value != null && value.getType().equals("LOG")) {
                JButton browseButton = GUIUtils.createImageButton((Icon)ApplicationImages.ICON_VIEWLOG_16);
                browseButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        try {
                            ClientProjectFile file = FileReportParameter.this.getClientProjectFile(value);
                            ApplicationUtils.runPreferredApp(FileParameterView.this.getWindow(), file);
                        }
                        catch (ApplicationException e) {
                            DesktopFrame desktop = DesktopFrame.getInstance();
                            DesktopComponentFrame frame = desktop.getDesktopFrame();
                            StandardErrorDialogs.showErrorDialog((Window)frame, e);
                        }
                    }
                });
                browseButton.setToolTipText(FileParameterView.this.getParameter().getDescription());
                return browseButton;
            }
            return null;
        }

        private ClientProjectFile getClientProjectFile(FileParameterValue paramValue) {
            CommonClientProject project = DesktopFrame.getInstance().getProject();
            String[] path = paramValue.getPathAsArray();
            ClientProjectFile file = GetFileTask.runTask(FileParameterView.this.getWindow(), project, path);
            return file;
        }

        @Override
        public void updateViewContents() {
            FileParameterValue value = (FileParameterValue)FileParameterView.this.getParameter().getValue();
            this.textField.setText(value == null ? " " : value.getPath());
        }
    }

    private static interface IFileParameterComponent {
        public void updateViewContents();
    }
}

