/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.ClientLocalFile;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.URLParameterView;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil;
import csbase.client.util.filechooser.ClientSGAFileChooserUtil;
import csbase.client.util.filechooser.util.ClientFileChooserUtils;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import csbase.logic.ClientSGAFile;
import csbase.logic.SGASet;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.OutputURLParameter;
import csbase.logic.algorithms.parameters.URLParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLValue;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SGAServiceInterface;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public class OutputURLParameterView
extends URLParameterView {
    public OutputURLParameterView(OutputURLParameter parameter, ParameterView.Mode mode) {
        super((URLParameter)parameter, mode);
    }

    @Override
    public OutputURLParameter getParameter() {
        return (OutputURLParameter)super.getParameter();
    }

    @Override
    protected URLValue askForFile(URLProtocol fileProtocol, Object ... args) {
        String fileType = this.getParameter().getFileType();
        ArrayList<String> fileTypes = new ArrayList<String>();
        if (fileType != null) {
            fileTypes.add(fileType);
        }
        ClientFileChooserSelectionMode selectionMode = this.getFileChooserMode();
        String title = this.getParameter().getLabel();
        switch (fileProtocol) {
            case PROJECT: {
                return this.askForProjectFile(fileTypes, true, selectionMode, title);
            }
            case LOCAL: {
                return this.askForLocalFile(fileTypes, true, selectionMode, title);
            }
            case SGA: {
                String sgaName = (String)args[0];
                return this.askForSGAFile(fileTypes, true, selectionMode, title, sgaName);
            }
        }
        return null;
    }

    private URLValue askForProjectFile(List<String> fileTypes, boolean allowAll, ClientFileChooserSelectionMode selectionMode, String title) {
        switch (selectionMode) {
            case DIRECTORIES_ONLY: {
                ClientProjectFileChooserUtil.OperationResult dirResult = ClientProjectFileChooserUtil.browseSingleDirectoryInSaveMode(this.getWindow(), title, allowAll);
                if (dirResult == null) break;
                ClientProjectFile dir = dirResult.getClientProjectFile();
                return this.getURLFromFile(URLProtocol.PROJECT, (ClientFile)dir, null);
            }
            case FILES_ONLY: {
                ClientProjectFileChooserUtil.OperationResult fileResult;
                String fileType = null;
                if (fileTypes != null && !fileTypes.isEmpty()) {
                    fileType = fileTypes.get(0);
                }
                if ((fileResult = ClientProjectFileChooserUtil.browseSingleFileInSaveMode(this.getWindow(), fileTypes, fileType, title, allowAll, true)) == null) break;
                ClientProjectFile file = fileResult.getClientProjectFile();
                return this.getURLFromFile(URLProtocol.PROJECT, (ClientFile)file, null);
            }
        }
        return null;
    }

    private URLValue askForLocalFile(List<String> fileTypes, boolean allowAll, ClientFileChooserSelectionMode selectionMode, String title) {
        switch (selectionMode) {
            case DIRECTORIES_ONLY: {
                ClientLocalFile localDir = ClientLocalFileChooserUtil.browseSingleDirectoryInSaveMode(this.getWindow(), fileTypes, null, title, allowAll, ClientFileChooserUtils.getLocalHomeDirectory());
                return this.getURLFromFile(URLProtocol.LOCAL, localDir, null);
            }
            case FILES_ONLY: {
                ClientLocalFile localFile = ClientLocalFileChooserUtil.browseSingleFileInSaveMode(this.getWindow(), fileTypes, null, title, allowAll, ClientFileChooserUtils.getLocalHomeDirectory());
                return this.getURLFromFile(URLProtocol.LOCAL, localFile, null);
            }
        }
        return null;
    }

    private URLValue askForSGAFile(List<String> fileTypes, boolean allowAll, ClientFileChooserSelectionMode selectionMode, String title, final String sgaName) {
        if (sgaName == null) {
            return null;
        }
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        RemoteTask<Boolean> sgaIsAliveTask = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                SGASet sga = sgaService.getSGASet(sgaName);
                this.setResult(sga.getAlive());
            }
        };
        boolean isAlive = false;
        String description = LNG.get((String)(String.valueOf(URLParameterView.class.getSimpleName()) + ".sga_alive_task"));
        if (sgaIsAliveTask.execute(this.getWindow(), title, description)) {
            isAlive = (Boolean)sgaIsAliveTask.getResult();
        }
        if (!isAlive) {
            String errorMessage = LNG.get((String)(String.valueOf(URLParameterView.class.getSimpleName()) + ".sga_not_alive"), (Object[])new Object[]{sgaName});
            StandardErrorDialogs.showErrorDialog(this.getWindow(), errorMessage);
            return null;
        }
        ClientSGAFile root = new ClientSGAFile(sgaName, "/");
        switch (selectionMode) {
            case DIRECTORIES_ONLY: {
                ClientSGAFile dir = ClientSGAFileChooserUtil.browseSingleDirectoryInSaveMode(this.getWindow(), title, fileTypes, root);
                return this.getURLFromFile(URLProtocol.SGA, (ClientFile)dir, sgaName);
            }
            case FILES_ONLY: {
                ClientSGAFile file = ClientSGAFileChooserUtil.browseSingleFileInSaveMode(this.getWindow(), title, fileTypes, root);
                return this.getURLFromFile(URLProtocol.SGA, (ClientFile)file, sgaName);
            }
        }
        return null;
    }

    private URLValue getURLFromFile(URLProtocol fileProtocol, ClientFile file, String host) {
        if (file == null) {
            return null;
        }
        String type = file.isDirectory() ? "DIRECTORY_TYPE" : file.getType();
        return new URLValue(file.getStringPath(), type, fileProtocol, host);
    }

    private ClientFileChooserSelectionMode getFileChooserMode() {
        FileParameterMode parameterMode = this.getParameter().getMode();
        switch (parameterMode) {
            case REGULAR_FILE: {
                return ClientFileChooserSelectionMode.FILES_ONLY;
            }
            case DIRECTORY: {
                return ClientFileChooserSelectionMode.DIRECTORIES_ONLY;
            }
        }
        String errorMessage = MessageFormat.format("O modo {0} n\u00e3o \u00e9 v\u00e1lido.", parameterMode);
        throw new IllegalStateException(errorMessage);
    }
}

