/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.tasks;

import csbase.client.algorithms.validation.ViewValidationResult;
import csbase.client.algorithms.validation.ViewValidator;
import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.Window;
import tecgraf.javautils.core.lng.LNG;

public class ViewValidationTask
extends RemoteTask<ViewValidationResult> {
    private final ViewValidator view;
    private final ValidationMode mode;
    private final boolean complain;

    public ViewValidationTask(ViewValidator view, ValidationMode mode, boolean complain) {
        this.view = view;
        this.mode = mode;
        this.complain = complain;
    }

    protected void performTask() throws Exception {
        ViewValidationResult validation = this.view.validate(this.mode);
        this.setResult((Object)validation);
    }

    protected void afterTaskUI() {
        ViewValidationResult result = (ViewValidationResult)((Object)this.getResult());
        if (result != null && this.complain) {
            this.view.highlightValidationResult(result);
        }
    }

    public static final ViewValidationResult runTask(Window window, ViewValidator view, ValidationMode mode, boolean complain) {
        String msg;
        ViewValidationTask task = new ViewValidationTask(view, mode, complain);
        String className = ViewValidationTask.class.getSimpleName();
        String title = LNG.get((String)(String.valueOf(className) + ".title"));
        if (task.execute(window, title, msg = LNG.get((String)(String.valueOf(className) + ".msg")))) {
            return (ViewValidationResult)((Object)task.getResult());
        }
        if (task.wasCancelled()) {
            LocalizedMessage message = new LocalizedMessage(ViewValidationTask.class, "cancelled");
            return new ViewValidationResult(message, view);
        }
        Exception error = task.getError();
        error.printStackTrace();
        LocalizedMessage message = new LocalizedMessage(ViewValidationTask.class, "error", new Object[]{error.getMessage()});
        return new ViewValidationResult(message, view);
    }
}

