/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager.resourcehelpers;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.applicationmanager.resourcehelpers.ApplicationResourceType;
import csbase.client.applications.Application;
import csbase.client.externalresources.ExternalResources;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import tecgraf.javautils.version.VersionNumber;

public class ApplicationResourceHelper<T extends Application> {
    private final T application;
    private final ApplicationResourceType resourceType;

    protected final T getApplication() {
        return this.application;
    }

    protected final ApplicationRegistry getApplicationRegistry() {
        ApplicationManager manager = ApplicationManager.getInstance();
        String appId = ((ApplicationType)this.application).getId();
        ApplicationRegistry registry = manager.getApplicationRegistry(appId);
        return registry;
    }

    public final InputStream getApplicationResourceAsStream(String tag) {
        String fileName = this.getUnversionedFileName(tag);
        String dirName = this.getResourceDirectoryName();
        String path = String.valueOf(dirName) + "/" + fileName;
        return ((ApplicationType)this.application).getApplicationResourceAsStream(path);
    }

    public final InputStream getApplicationResourceAsStream(String tag, VersionNumber version) {
        version.check();
        String fileName = this.getVersionedFileName(tag, version);
        String dirName = this.getResourceDirectoryName();
        String path = String.valueOf(dirName) + "/" + tag + "/" + fileName;
        InputStream stream = ((ApplicationType)this.application).getApplicationResourceAsStream(path);
        return stream;
    }

    public final URL getApplicationResourceAsURL(String tag) {
        String fileName = this.getUnversionedFileName(tag);
        String dirName = this.getResourceDirectoryName();
        String path = String.valueOf(dirName) + "/" + fileName;
        return ((ApplicationType)this.application).getApplicationResourceAsURL(path);
    }

    public final String getApplicationResourceAsURLText(String tag, VersionNumber version) {
        String fileName = this.getVersionedFileName(tag, version);
        String urlText = this.getURLText(fileName);
        return urlText;
    }

    public final String getURLText(String fileName) {
        ApplicationManager appManager = ApplicationManager.getInstance();
        ApplicationRegistry reg = this.getApplicationRegistry();
        String dirName = this.getResourceDirectoryName();
        ExternalResources externalResources = ExternalResources.getInstance();
        String sufixPath = "resources/" + dirName + "/" + fileName;
        if (externalResources.isEnabled()) {
            String codeBaseText;
            try {
                URL codeBase = externalResources.getCodeBase();
                codeBaseText = codeBase.toString();
            }
            catch (Exception e) {
                codeBaseText = "http://";
            }
            String urlText = String.valueOf(codeBaseText) + "/" + sufixPath;
            return urlText;
        }
        File pwdFile = new File(".");
        String pwdPath = pwdFile.getAbsolutePath();
        String pckName = appManager.getApplicationFullPackageName(reg);
        String dirPath = pckName.replaceAll("\\.", "/");
        String filePath = String.valueOf(pwdPath) + "/" + dirPath + "/" + sufixPath;
        String urlText = "file://" + filePath;
        return urlText;
    }

    public final String getResourceURLPrefix() {
        ApplicationManager appManager = ApplicationManager.getInstance();
        ApplicationRegistry reg = this.getApplicationRegistry();
        String dirName = this.getResourceDirectoryName();
        ExternalResources externalResources = ExternalResources.getInstance();
        String sufixPath = "resources/" + dirName;
        if (externalResources.isEnabled()) {
            String codeBaseText;
            try {
                URL codeBase = externalResources.getCodeBase();
                codeBaseText = codeBase.toString();
            }
            catch (Exception e) {
                codeBaseText = "http://";
            }
            String urlPrefix = String.valueOf(codeBaseText) + "/" + sufixPath + "/";
            return urlPrefix;
        }
        File pwdFile = new File(".");
        String pwdPath = pwdFile.getAbsolutePath();
        String pckName = appManager.getApplicationFullPackageName(reg);
        String dirPath = pckName.replaceAll("\\.", "/");
        String filePath = String.valueOf(pwdPath) + "/" + dirPath + "/" + sufixPath;
        String urlPrefix = "file://" + filePath + "/";
        return urlPrefix;
    }

    public final URL getApplicationResourceAsURL(String tag, VersionNumber version) {
        version.check();
        String fileName = this.getVersionedFileName(tag, version);
        String dirName = this.getResourceDirectoryName();
        String path = String.valueOf(dirName) + "/" + tag + "/" + fileName;
        URL url = ((ApplicationType)this.application).getApplicationResourceAsURL(path);
        return url;
    }

    public final String getVersionedFileName(String tag, VersionNumber version) {
        String realTag = this.checkTag(tag);
        if (version == null) {
            String err = "Null version detected!";
            throw new IllegalArgumentException("Null version detected!");
        }
        String vTxt = version.toString();
        String ext = this.getFileExtension();
        String fileName = String.valueOf(realTag) + "-" + vTxt + "." + ext;
        return fileName;
    }

    public final String getUnversionedFileName(String tag) {
        String realTag = this.checkTag(tag);
        ApplicationManager appManager = ApplicationManager.getInstance();
        ApplicationRegistry reg = this.getApplicationRegistry();
        String pckText = appManager.getApplicationPackageName(reg);
        String ext = this.getFileExtension();
        String fileName = String.valueOf(pckText) + "-" + realTag + "." + ext;
        return fileName;
    }

    private String checkTag(String tag) {
        if (tag == null) {
            String err = "Null tag not allowed.";
            throw new IllegalArgumentException("Null tag not allowed.");
        }
        return tag.trim();
    }

    public final VersionNumber getResourceVersionFromProperty(String tag) {
        String newTag = this.checkTag(tag);
        String prefix = "resource." + this.getResourceTypeId();
        String sufix = "version";
        String appPropName = String.valueOf(prefix) + "." + newTag + "." + "version";
        ApplicationRegistry reg = this.getApplicationRegistry();
        String versionText = reg.getStringSpecificProperty(appPropName);
        VersionNumber version = VersionNumber.fromString((String)versionText);
        return version;
    }

    protected String getResourceDirectoryName() {
        String resourceTypeId = this.getResourceTypeId();
        return resourceTypeId;
    }

    protected final String getResourceTypeId() {
        String name = this.resourceType.name();
        String lowerCaseName = name.toLowerCase();
        return lowerCaseName;
    }

    protected String getFileExtension() {
        String resourceTypeId = this.getResourceTypeId();
        return resourceTypeId;
    }

    public ApplicationResourceHelper(T application, ApplicationResourceType resourceType) {
        this.application = application;
        this.resourceType = resourceType;
    }

    public final ApplicationResourceType getResourceType() {
        return this.resourceType;
    }
}

