/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager.resourcehelpers;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GUIUtils;

public class ApplicationSelectionDialog
extends JDialog {
    private final JList list = new JList();

    public ApplicationSelectionDialog(Window owner) {
        this(owner, ApplicationManager.getInstance().getAllApplicationRegistries());
    }

    public ApplicationSelectionDialog(Window owner, List<ApplicationRegistry> regs) {
        super(owner, "", Dialog.ModalityType.DOCUMENT_MODAL);
        ApplicationManager manager = ApplicationManager.getInstance();
        final Locale locale = manager.getLocale();
        Collections.sort(regs, new Comparator<ApplicationRegistry>(){

            @Override
            public int compare(ApplicationRegistry o1, ApplicationRegistry o2) {
                String n1 = o1.getApplicationName(locale);
                String n2 = o2.getApplicationName(locale);
                return n1.compareTo(n2);
            }
        });
        this.initListAttributes(regs);
        this.setLayout(new BorderLayout());
        JButton okButton = new JButton(this.getClassString("ok.button"));
        JButton cancelButton = new JButton(this.getClassString("cancel.button"));
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{okButton, cancelButton});
        okButton.setEnabled(false);
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        buttonsPanel.add(cancelButton);
        buttonsPanel.add(okButton);
        JScrollPane pane = new JScrollPane(this.list);
        BorderUtil.setLowBorder((JComponent)pane);
        this.add((Component)pane, "Center");
        this.add((Component)buttonsPanel, "South");
        this.setLocationRelativeTo(this.getOwner());
        this.setUpButtons(okButton, cancelButton);
        this.setUpListeners(okButton);
        this.setMinimumSize(new Dimension(400, 300));
        this.pack();
    }

    private void initListAttributes(final List<ApplicationRegistry> regs) {
        this.list.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return regs.size();
            }

            @Override
            public Object getElementAt(int index) {
                return regs.get(index);
            }
        });
        this.list.setSelectionMode(2);
        this.list.setLayoutOrientation(0);
        this.list.setCellRenderer(this.buildCellRenderer());
    }

    private void setUpButtons(JButton okButton, JButton cancelButton) {
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationSelectionDialog.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationSelectionDialog.this.setVisible(false);
                ApplicationSelectionDialog.this.list.clearSelection();
            }
        });
    }

    private void setUpListeners(final JButton okButton) {
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                okButton.setEnabled(ApplicationSelectionDialog.this.list.getSelectedValue() != null);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    okButton.doClick();
                }
            }
        });
    }

    public List<String> getSelectedApplications() {
        if (this.list.getSelectedIndices() == null) {
            return null;
        }
        Object[] indices = this.list.getSelectedValues();
        ArrayList<String> apps = new ArrayList<String>(indices.length);
        Object[] objectArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            apps.add(obj.toString());
            ++n2;
        }
        return apps;
    }

    private ListCellRenderer buildCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jlist, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)jlist, value, index, isSelected, cellHasFocus);
                ApplicationRegistry reg = (ApplicationRegistry)value;
                String id = reg.getId();
                ApplicationManager manager = ApplicationManager.getInstance();
                ImageIcon icon = manager.getApplicationIcon(id);
                String name = manager.getApplicationName(reg);
                this.setIcon(icon);
                this.setText(name);
                this.setHorizontalAlignment(10);
                return this;
            }
        };
    }

    private String getClassString(String key) {
        return LNG.get((String)(String.valueOf(this.getClass().getSimpleName()) + "." + key));
    }
}

