/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager.resourcehelpers;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class PreferredAppDialog
extends JDialog {
    private JList appList;
    private JCheckBox saveCheckBox;
    private boolean saveOption;
    private JButton ok;
    private JButton cancel;

    public PreferredAppDialog(Window owner, List<String> apps, String fileType, boolean saveOption) {
        super(owner, "", Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle(this.getString("title"));
        this.setLayout(new GridBagLayout());
        this.appList = new JList<Object>(apps.toArray());
        this.appList.setSelectionMode(0);
        this.appList.setLayoutOrientation(0);
        this.appList.setCellRenderer(this.buildCellRenderer());
        this.saveCheckBox = new JCheckBox(this.getString("save.as.preferred"));
        this.saveOption = saveOption;
        this.ok = new JButton("Ok");
        this.ok.setEnabled(false);
        this.cancel = new JButton(LNG.get((String)"UTIL_CANCEL"));
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{this.ok, this.cancel});
        this.buildInterface();
        this.setLocationRelativeTo(this.getOwner());
        this.setUpButtons(fileType);
        this.setUpListeners();
        this.setMinimumSize(new Dimension(300, 300));
        this.pack();
    }

    private void buildInterface() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.appList), new GBC(0, 0).west().both());
        if (this.saveOption) {
            panel.add((Component)this.saveCheckBox, new GBC(0, 1).west());
        }
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.add((Component)new JLabel(), new GBC(0, 0).horizontal());
        buttonsPanel.add((Component)this.cancel, new GBC(1, 0).west().bottom(10).left(10).right(5));
        buttonsPanel.add((Component)this.ok, new GBC(2, 0).west().bottom(10).left(5).right(10));
        this.add((Component)panel, new GBC(0, 0).both().insets(10));
        this.add((Component)buttonsPanel, new GBC(0, 1).horizontal());
    }

    private void setUpButtons(String fileType) {
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferredAppDialog.this.setVisible(false);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferredAppDialog.this.setVisible(false);
                PreferredAppDialog.this.appList.clearSelection();
            }
        });
    }

    private void setUpListeners() {
        this.appList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PreferredAppDialog.this.ok.setEnabled(PreferredAppDialog.this.appList.getSelectedValue() != null);
            }
        });
        this.appList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PreferredAppDialog.this.ok.doClick();
                }
            }
        });
    }

    public String getSelectedApp() {
        if (this.appList != null && this.appList.getSelectedValue() != null) {
            return this.appList.getSelectedValue().toString();
        }
        return null;
    }

    public boolean toSave() {
        return this.saveOption && this.saveCheckBox.isSelected();
    }

    private ListCellRenderer buildCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String appId = value.toString();
                ApplicationManager am = ApplicationManager.getInstance();
                ImageIcon icon = am.getApplicationIcon(appId);
                ApplicationRegistry appReg = am.getApplicationRegistry(appId);
                String name = am.getApplicationName(appReg);
                this.setIcon(icon);
                this.setText(name);
                this.setHorizontalAlignment(10);
                return this;
            }
        };
    }

    private String getString(String key) {
        return LNG.get((String)(String.valueOf(this.getClass().getSimpleName()) + "." + key));
    }
}

