/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.applications.ApplicationComponentFrame;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceManager;
import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.util.PreferenceListener;
import csbase.client.preferences.util.PreferencesUtil;
import csbase.client.remote.srvproxies.EventLogProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommonClientProject;
import csbase.logic.applicationservice.AppPropertyResourceBundle;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public abstract class Application
extends ApplicationType {
    @Deprecated
    public static final String PROJECT_FILE_MESSAGE = "PROJECT_FILE";
    public static final String PREFERENCE_MESSAGE = "PREFERENCE_MESSAGE";
    private final ApplicationFrame mainFrame;
    private JLabel statusBar;
    private final ArrayList<Window> dependentWindows = new ArrayList();
    private int initialFrameState;
    private Map<PreferenceDefinition, List<PreferenceListener<?>>> preferenceListeners;
    private Map<String, String> keyNotFoundInAnyIdiom;
    private Map<String, String> keyNotFoundInSelectedIdiom;

    private void buildStatusBar() {
        this.statusBar = new JLabel();
        this.statusBar.setHorizontalAlignment(2);
    }

    @Deprecated
    public JLabel getStatusBar() {
        return this.statusBar;
    }

    public Locale getLocale() {
        return ApplicationManager.getInstance().getLocale();
    }

    public final DesktopFrame getDesktopFrame() {
        DesktopFrame dsk = DesktopFrame.getInstance();
        if (dsk == null) {
            String err = "Internal Error: no desktop found for application!";
            throw new RuntimeException("Internal Error: no desktop found for application!");
        }
        return dsk;
    }

    public final CommonClientProject getApplicationProject() {
        DesktopFrame dsk = this.getDesktopFrame();
        ApplicationRegistry reg = this.getApplicationRegistry();
        CommonClientProject prj = dsk.getProject();
        if (prj != null) {
            return prj;
        }
        if (reg.requireProject()) {
            String err = "No project found for application that requires one!";
            throw new IllegalStateException("No project found for application that requires one!");
        }
        return null;
    }

    public final String getApplicationCommand() {
        return this.getApplicationRegistry().getApplicationCommand();
    }

    public final String getApplicationCommandDir() {
        return this.getApplicationRegistry().getApplicationCommandDir();
    }

    public final boolean isConnectedToServer() {
        return true;
    }

    public final ImageIcon buildApplicationImage(String tag) {
        ImageIcon image = this.getImageIcon(String.valueOf(tag) + ".gif");
        if (image == null) {
            return ApplicationImages.ICON_NONE;
        }
        return image;
    }

    public final ApplicationComponentFrame buildApplicationFrame() {
        return new ApplicationComponentFrame(this);
    }

    public final ApplicationFrame getApplicationFrame() {
        return this.mainFrame;
    }

    public final AppPropertyResourceBundle getResourceBundle() {
        ApplicationRegistry reg = this.getApplicationRegistry();
        return reg.getResourceBundle();
    }

    public final boolean hasString(String key) {
        ApplicationRegistry reg = this.getApplicationRegistry();
        return reg.hasString(key);
    }

    public final String getString(String key) {
        ApplicationRegistry reg = this.getApplicationRegistry();
        return reg.getString(key);
    }

    public final String getString(String key, Object[] args) {
        ApplicationRegistry reg = this.getApplicationRegistry();
        return reg.getString(key, args);
    }

    public final boolean hasClassString(Class<?> clazz, String key) {
        ApplicationRegistry reg = this.getApplicationRegistry();
        return reg.hasClassString(clazz, key);
    }

    public final String getClassString(Class<?> clazz, String key) {
        ApplicationRegistry reg = this.getApplicationRegistry();
        return reg.getClassString(clazz, key);
    }

    public final String getClassString(Class<?> clazz, String key, Object[] args) {
        ApplicationRegistry reg = this.getApplicationRegistry();
        return reg.getClassString(clazz, key, args);
    }

    public final InputStream getResource(String[] resourcePath) {
        ApplicationManager manager = ApplicationManager.getInstance();
        ApplicationRegistry registry = this.getApplicationRegistry();
        ApplicationFrame frame = this.getApplicationFrame();
        return manager.getApplicationResource(frame, registry, resourcePath);
    }

    @Override
    public void startApplication() throws ApplicationException {
        DesktopFrame desktop = DesktopFrame.getInstance();
        DesktopComponentFrame frame = desktop.getDesktopFrame();
        this.mainFrame.setTitle(this.getName());
        ApplicationManager manager = ApplicationManager.getInstance();
        ApplicationRegistry reg = manager.getApplicationRegistry(this.getId());
        byte[] iconDefinition = reg.getIconDefinition();
        if (iconDefinition != null) {
            ImageIcon imageIcon = new ImageIcon(iconDefinition);
            this.mainFrame.setIconImage(imageIcon.getImage());
        }
        if (this.initialFrameState != 0) {
            this.mainFrame.pack();
            this.mainFrame.setExtendedState(this.initialFrameState);
            this.mainFrame.validate();
        }
        if (frame == null) {
            Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
            this.mainFrame.center(defaultToolkit.getScreenSize(), 0, 0);
        } else {
            this.mainFrame.center(frame);
        }
        this.mainFrame.setVisible(reg.mainFrameIsVisible());
        this.mainFrame.toFront();
    }

    @Override
    public final void finishApplication() {
        PreferenceManager pm;
        String notIdiom;
        this.closeDependentWindows();
        this.mainFrame.setVisible(false);
        this.mainFrame.delApplicationManagerListener();
        ApplicationManager manager = ApplicationManager.getInstance();
        manager.notifyDeath(this);
        this.mainFrame.close();
        String[] aQueue = manager.getApplicationManagerEventQueue();
        String notAny = this.getTextNotFoundInAnyIdiom();
        if (notAny != null && !notAny.trim().isEmpty()) {
            String[] msg = new String[]{"Textos sem chave em qualquer idioma:\n", notAny};
            EventLogProxy.addClientInformation(aQueue, msg);
        }
        if ((notIdiom = this.getTextNotFoundInSelectedIdiom()) != null && !notIdiom.trim().isEmpty()) {
            String[] msg = new String[]{"Textos sem chave no idioma " + LNG.getLocale() + ":\n", notIdiom};
            EventLogProxy.addClientInformation(aQueue, msg);
        }
        if ((pm = PreferenceManager.getInstance()).hasAppPreferences(this.getApplicationRegistry())) {
            this.removeAllPreferenceListeners();
        }
    }

    private String getTextNotFoundInAnyIdiom() {
        StringBuffer textNotFound = new StringBuffer("");
        for (String key : this.keyNotFoundInAnyIdiom.keySet()) {
            textNotFound.append(key);
            textNotFound.append(": ");
            textNotFound.append(this.keyNotFoundInSelectedIdiom.get(key));
            textNotFound.append("\n");
        }
        return textNotFound.toString();
    }

    private String getTextNotFoundInSelectedIdiom() {
        StringBuffer textWithoutTranslation = new StringBuffer("");
        for (String key : this.keyNotFoundInSelectedIdiom.keySet()) {
            textWithoutTranslation.append(key);
            textWithoutTranslation.append(": ");
            textWithoutTranslation.append(this.keyNotFoundInSelectedIdiom.get(key));
            textWithoutTranslation.append("\n");
        }
        return textWithoutTranslation.toString();
    }

    public final void logDetailedApplicationEvent(String[] queue, String[] info) {
        ApplicationManager mgr = ApplicationManager.getInstance();
        String[] aQueue = mgr.getApplicationEventQueue(this, queue);
        EventLogProxy.addClientInformation(aQueue, info);
    }

    public final void showMessage(Object msg) {
        String title = this.getApplicationFrame().getTitle();
        this.showMessage(this.mainFrame, title, msg, 1);
    }

    public final void showMessage(Component parent, String title, Object msg, int type) {
        Component father = parent == null ? this.mainFrame : parent;
        JOptionPane.showMessageDialog(father, msg, title, type);
    }

    public final int showOptionDialog(Component parent, String msg, String[] options) {
        String title = this.getName();
        return StandardDialogs.showOptionDialog((Component)parent, (String)title, (Object)msg, (Object[])options);
    }

    public final int showOptionDialog(String msg, String[] options) {
        return this.showOptionDialog(this.mainFrame, msg, options);
    }

    public final void showExceptionStack(Throwable t) {
        StandardErrorDialogs.showExceptionDialog(this.mainFrame, this.getName(), t);
    }

    public final void showException(String msg, Throwable t) {
        StandardErrorDialogs.showErrorDialog(this.mainFrame, this.getName(), msg, t);
    }

    public final void showError(Object msg) {
        ApplicationFrame frame = this.getApplicationFrame();
        this.showError(frame, msg);
    }

    public final void showError(Component parent, Object msg) {
        this.showMessage(parent, this.getName(), msg, 0);
    }

    public final void showInformation(Component parent, Object msg) {
        this.showMessage(parent, this.getName(), msg, 1);
    }

    public final void showInformation(Object msg) {
        this.showInformation(null, msg);
    }

    public final void showWarning(Component parent, Object msg) {
        this.showMessage(parent, this.getName(), msg, 2);
    }

    public final void showWarning(Object msg) {
        this.showWarning(null, msg);
    }

    public final void addWindow(Window win) {
        this.dependentWindows.add(win);
    }

    public final void removeWindow(Window win) {
        this.dependentWindows.remove(win);
    }

    public final void closeDependentWindows() {
        ArrayList<Window> aux = new ArrayList<Window>();
        aux.addAll(this.dependentWindows);
        for (Window window : aux) {
            window.setVisible(false);
            window.dispose();
        }
        this.dependentWindows.clear();
    }

    public final boolean isVisible() {
        return this.mainFrame.isVisible();
    }

    public final void setVisible(boolean flag) {
        this.mainFrame.setVisible(flag);
    }

    public final PreferenceCategory getPreferences() {
        ApplicationFrame frame = this.getApplicationFrame();
        ApplicationRegistry registry = this.getApplicationRegistry();
        PreferenceManager pm = PreferenceManager.getInstance();
        return pm.loadAppPreferences(registry, frame);
    }

    public final void savePreferences() {
        PreferenceManager.getInstance().savePreferences(this.getApplicationFrame());
    }

    protected Application(String id) {
        super(id);
        this.setInitialFrameState(0);
        this.keyNotFoundInAnyIdiom = new HashMap<String, String>();
        this.keyNotFoundInSelectedIdiom = new HashMap<String, String>();
        ApplicationRegistry reg = ApplicationManager.getInstance().getApplicationRegistry(id);
        reg.setTranslationListener(new LNG.TranslationListener(){

            public String keyNotFound(String key, String text) {
                Application.this.keyNotFoundInAnyIdiom.put(key, text);
                return text;
            }

            public String keyNotFoundInDefaultLanguage(String key, String text) {
                Application.this.keyNotFoundInSelectedIdiom.put(key, text);
                return text;
            }
        });
        this.mainFrame = new ApplicationFrame(this, id);
        this.mainFrame.addApplicationManagerListener();
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Application.this.closeApplication();
            }
        });
        this.preferenceListeners = new HashMap();
        this.buildStatusBar();
    }

    protected <T> void addPreferenceListener(PreferenceDefinition name, PreferenceListener<T> listener) {
        PreferenceCategory pc = PreferencesUtil.deepSearch(name, this.getPreferences());
        PreferenceValue<?> preference = pc.getPreference(name);
        preference.addPreferenceListener(listener);
        if (!this.preferenceListeners.containsKey(name)) {
            this.preferenceListeners.put(name, new LinkedList());
        }
        this.preferenceListeners.get(name).add(listener);
    }

    protected <T> void removeAllPreferenceListeners() {
        for (PreferenceDefinition name : this.preferenceListeners.keySet()) {
            PreferenceCategory cat = PreferencesUtil.deepSearch(name, this.getPreferences());
            PreferenceValue<?> preference = cat.getPreference(name);
            Iterator<PreferenceListener<?>> iterator = this.preferenceListeners.get(name).iterator();
            while (iterator.hasNext()) {
                PreferenceListener<?> l;
                PreferenceListener<?> listener = l = iterator.next();
                preference.removePreferenceListener(listener);
            }
        }
    }

    protected boolean handleError(Exception ex) {
        return false;
    }

    protected final void setInitialFrameState(int initState) {
        this.initialFrameState = initState;
    }

    @Override
    public abstract void killApplication() throws ApplicationException;
}

