/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationProject;
import csbase.client.desktop.CommandListener;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandEndNotification;
import csbase.logic.CommandErrorNotification;
import csbase.logic.CommandFailedNotification;
import csbase.logic.CommandKilledNotification;
import csbase.logic.CommandLostNotification;
import csbase.logic.CommandNotification;
import csbase.logic.CommandSuccessNotification;
import csbase.logic.CommandWithNoExitCodeNotification;
import csbase.logic.CommonClientProject;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.awt.Component;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.StatusBar;

public class ApplicationCommandAdapter
implements CommandListener {
    private Object commandId;
    private boolean handleFinishedCommand;
    private boolean remove;
    private String[] dataFilePath;
    private ApplicationProject app;
    private String executionName;

    public ApplicationCommandAdapter(Object commandId, String[] dataFilePath, String executionName, ApplicationProject application) {
        this.commandId = commandId;
        this.dataFilePath = dataFilePath;
        this.app = application;
        this.remove = false;
        this.executionName = executionName;
        this.handleFinishedCommand = false;
    }

    public ApplicationProject getApplication() {
        return this.app;
    }

    public Object getCommandId() {
        return this.commandId;
    }

    public String[] getDataFilePath() {
        return this.dataFilePath;
    }

    public void handleFinishedCommand(boolean state) {
        this.handleFinishedCommand = state;
    }

    protected String getFileName(String[] filePath) {
        if (filePath.length == 0) {
            return null;
        }
        return filePath[filePath.length - 1];
    }

    @Override
    public void notifyCommand(CommandNotification data) {
        if (!this.commandId.equals(data.getCommandId())) {
            return;
        }
        if (data instanceof CommandEndNotification) {
            this.notifyCommandFinished((CommandEndNotification)data);
            if (ApplicationManager.getInstance().isApplicationRunning(this.app)) {
                this.notifyCommandFinished();
            }
        } else if (data instanceof CommandSuccessNotification) {
            this.notifyCommandSuccess((CommandSuccessNotification)data);
            if (ApplicationManager.getInstance().isApplicationRunning(this.app)) {
                this.notifyCommandFinished();
            }
        } else if (data instanceof CommandErrorNotification) {
            this.notifyCommandError((CommandErrorNotification)data);
            if (ApplicationManager.getInstance().isApplicationRunning(this.app)) {
                this.notifyCommandFinished();
            }
        } else if (data instanceof CommandWithNoExitCodeNotification) {
            this.notifyCommandWithNoExitCode((CommandWithNoExitCodeNotification)data);
            if (ApplicationManager.getInstance().isApplicationRunning(this.app)) {
                this.notifyCommandFinished();
            }
        } else if (data instanceof CommandFailedNotification) {
            this.notifyCommandFailed((CommandFailedNotification)data);
        } else if (data instanceof CommandKilledNotification) {
            this.notifyCommandKilled((CommandKilledNotification)data);
        } else if (data instanceof CommandLostNotification) {
            this.notifyCommandLost((CommandLostNotification)data);
        }
        this.remove = true;
    }

    public void notifyCommandFinished() {
    }

    @Override
    public boolean shouldRemove() {
        return this.remove;
    }

    protected boolean isDataFileInCurrentProject() {
        DesktopFrame desktop = DesktopFrame.getInstance();
        ClientProjectFile file = this.app.stringArrayToFile(this.dataFilePath);
        CommonClientProject proj = desktop.getProject();
        if (proj == null || file == null || !file.getProjectId().equals(proj.getId())) {
            String title = String.format(LNG.get((String)"ApplicationCommandAdapter.title.finished"), this.executionName, this.getFileName(this.dataFilePath));
            String msg = String.format(LNG.get((String)"ApplicationCommandAdapter.info.finished.otherProject"), this.executionName, this.getFileName(this.dataFilePath), this.executionName);
            StandardDialogs.showInfoDialog((Component)desktop.getDesktopFrame(), (String)title, (Object)msg);
            return false;
        }
        return true;
    }

    protected void notifyCommandFinished(CommandEndNotification data) {
        String title = String.format(LNG.get((String)"ApplicationCommandAdapter.title.finished"), this.executionName, this.getFileName(this.dataFilePath));
        String msg = String.valueOf(data.getCmdDesc()) + " - " + data.getCommandId();
        this.notifyCommandExecuted((CommandNotification)data, title, msg);
    }

    protected void notifyCommandSuccess(CommandSuccessNotification data) {
        String title = String.format(LNG.get((String)"ApplicationCommandAdapter.title.success"), this.executionName, this.getFileName(this.dataFilePath));
        String msg = String.format(LNG.get((String)"ApplicationCommandAdapter.info.success"), this.getFileName(this.dataFilePath));
        this.notifyCommandExecuted((CommandNotification)data, title, msg);
    }

    protected void notifyCommandError(CommandErrorNotification data) {
        String title = String.format(LNG.get((String)"ApplicationCommandAdapter.title.error"), this.executionName, this.getFileName(this.dataFilePath));
        String msg = String.format(LNG.get((String)"ApplicationCommandAdapter.info.error"), this.executionName, this.getFileName(this.dataFilePath));
        this.notifyCommandExecuted((CommandNotification)data, title, msg);
    }

    protected void notifyCommandWithNoExitCode(CommandWithNoExitCodeNotification data) {
        String title = String.format(LNG.get((String)"ApplicationCommandAdapter.title.no_code"), this.executionName, this.getFileName(this.dataFilePath));
        String msg = String.format(LNG.get((String)"ApplicationCommandAdapter.info.no_code"), this.executionName, this.getFileName(this.dataFilePath));
        this.notifyCommandExecuted((CommandNotification)data, title, msg);
    }

    private void notifyCommandExecuted(CommandNotification data, String title, String message) {
        if (!this.isDataFileInCurrentProject()) {
            return;
        }
        if (this.handleFinishedCommand) {
            this.notifyCommandFinalizationStatus(title, message);
        }
    }

    private void notifyCommandFinalizationStatus(String title, String message) {
        ApplicationFrame applicationFrame = this.app.getApplicationFrame();
        StatusBar statusBar = applicationFrame.getStatusBar();
        statusBar.clearStatus();
        DesktopFrame desktop = DesktopFrame.getInstance();
        DesktopComponentFrame frame = desktop.getDesktopFrame();
        StandardDialogs.showInfoDialog((Component)frame, (String)title, (Object)message);
    }

    protected void notifyCommandKilled(CommandKilledNotification data) {
        final ClientProjectFile dataFile = this.app.stringArrayToFile(this.dataFilePath);
        if (dataFile == null) {
            return;
        }
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                ProjectServiceInterface projectService = ClientRemoteLocator.projectService;
                Object projectId = dataFile.getProjectId();
                String[] path = dataFile.getPath();
                projectService.setUnderConstruction(projectId, path, false);
            }
        };
        DesktopFrame dskFrame = DesktopFrame.getInstance();
        DesktopComponentFrame frame = dskFrame.getDesktopFrame();
        task.execute(frame, this.app.getName(), this.getString("ApplicationCommandAdapter.info.log.failed"));
        String title = String.format(LNG.get((String)"ApplicationCommandAdapter.title.killed"), this.executionName, this.getFileName(this.dataFilePath));
        String msg = String.format(LNG.get((String)"ApplicationCommandAdapter.info.killed"), this.executionName, this.getFileName(this.dataFilePath));
        this.notifyCommandFinalizationStatus(title, msg);
    }

    public final String getString(String key) {
        return this.app.getString(key);
    }

    protected void notifyCommandFailed(CommandFailedNotification data) {
        String title = String.format(LNG.get((String)"ApplicationCommandAdapter.title.failed"), this.executionName, this.getFileName(this.dataFilePath));
        String msg = String.format(LNG.get((String)"ApplicationCommandAdapter.info.failed"), this.executionName, this.getFileName(this.dataFilePath));
        this.notifyCommandFinalizationStatus(title, msg);
    }

    protected void notifyCommandLost(CommandLostNotification data) {
        String title = String.format(LNG.get((String)"ApplicationCommandAdapter.title.failed"), this.executionName, this.getFileName(this.dataFilePath));
        String msg = String.format(LNG.get((String)"ApplicationCommandAdapter.info.failed"), this.executionName, this.getFileName(this.dataFilePath));
        this.notifyCommandFinalizationStatus(title, msg);
    }
}

