/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.Application;
import csbase.client.applications.algorithmsmanager.dialogs.CategorySelectionPanel;
import csbase.client.applications.algorithmsmanager.models.CategoryNodeInterface;
import csbase.client.applications.algorithmsmanager.models.CategoryTreeNode;
import csbase.client.applications.algorithmsmanager.models.CategoryTreeRootNode;
import csbase.client.applications.algorithmsmanager.models.DataInterface;
import csbase.logic.algorithms.Category;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import tecgraf.javautils.gui.tree.DefaultNode;
import tecgraf.javautils.gui.tree.FilterableTreePanel;
import tecgraf.javautils.gui.tree.Node;

public class CategoryTreeView {
    private CategorySelectionPanel categorySelectionPanel;
    private FilterableTreePanel categoryTreePanel;
    private SortedSet<Category> nodes;
    public static String ROOT_NAME;
    private Vector<TreePath> expandedTreePathList;
    private Rectangle visibleRectangle;
    private boolean alreadySelected;
    private int currentCategoryRow;
    private TreeSelectionListener treeSelectionListener;

    public CategoryTreeView(CategorySelectionPanel categorySelectionPanel, SortedSet<Category> nodes) {
        this.setNodes(nodes);
        this.categorySelectionPanel = categorySelectionPanel;
        this.currentCategoryRow = -1;
        ROOT_NAME = this.getApplication().getString("CategoryTreeView.root.label.categories");
    }

    private Application getApplication() {
        return this.categorySelectionPanel.getApplication();
    }

    private void setNodes(SortedSet<Category> nodes) {
        this.nodes = nodes;
    }

    public FilterableTreePanel getTreePanel() {
        if (this.categoryTreePanel == null) {
            this.categoryTreePanel = this.createDataTreePanel();
        }
        return this.categoryTreePanel;
    }

    private FilterableTreePanel createDataTreePanel() {
        if (this.treeSelectionListener != null) {
            this.getCategoryTree().getSelectionModel().removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.categoryTreePanel = new FilterableTreePanel((Node)new CategoryTreeRootNode(this.nodes));
        this.createTreeSelectionListener();
        this.getCategoryTree().getSelectionModel().setSelectionMode(4);
        return this.categoryTreePanel;
    }

    private void createTreeSelectionListener() {
        this.treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object node = e.getPath().getLastPathComponent();
                CategoryNodeInterface categoryNode = null;
                if (node instanceof CategoryNodeInterface) {
                    categoryNode = (CategoryNodeInterface)node;
                }
                CategoryTreeView.this.initCategorySelection(categoryNode);
            }
        };
        this.getCategoryTree().getSelectionModel().addTreeSelectionListener(this.treeSelectionListener);
    }

    private JTree getCategoryTree() {
        return this.categoryTreePanel.getTree();
    }

    public CategoryNodeInterface getFirstSelectedNode() {
        CategoryNodeInterface node = null;
        JTree dataTree = this.categoryTreePanel.getTree();
        int selectedCount = dataTree.getSelectionCount();
        if (selectedCount == 1) {
            Object selectionPath = dataTree.getSelectionPath().getLastPathComponent();
            node = (CategoryNodeInterface)selectionPath;
        }
        return node;
    }

    public int getSelectedRow() {
        JTree dataTree = this.categoryTreePanel.getTree();
        int[] selectionRows = dataTree.getSelectionRows();
        if (selectionRows != null && selectionRows.length > 0) {
            return selectionRows[0];
        }
        return 0;
    }

    public List<DataInterface> getSelectedDataList() {
        ArrayList<DataInterface> selectedDataList = new ArrayList<DataInterface>();
        JTree dataTree = this.categoryTreePanel.getTree();
        TreePath[] selectionPaths = dataTree.getSelectionPaths();
        if (selectionPaths != null) {
            TreePath[] treePathArray = selectionPaths;
            int n = selectionPaths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath treePath = treePathArray[n2];
                Object treeNode = treePath.getLastPathComponent();
                if (treeNode instanceof CategoryNodeInterface) {
                    selectedDataList.add((CategoryNodeInterface)treeNode);
                }
                ++n2;
            }
        }
        return selectedDataList;
    }

    public List<CategoryNodeInterface> getFullPathSelectedNode() {
        ArrayList<CategoryNodeInterface> fullPath = new ArrayList<CategoryNodeInterface>();
        JTree dataTree = this.getCategoryTree();
        int selectedCount = dataTree.getSelectionCount();
        if (selectedCount == 1) {
            Object[] paths = dataTree.getSelectionPath().getPath();
            CategoryTreeRootNode rootNode = (CategoryTreeRootNode)paths[0];
            fullPath.add(rootNode);
            Object[] objectArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                Object path = objectArray[n2];
                if (path instanceof CategoryTreeNode) {
                    CategoryTreeNode node = (CategoryTreeNode)path;
                    fullPath.add(node);
                }
                ++n2;
            }
        }
        return fullPath;
    }

    public CategoryTreeRootNode getRootNode() {
        TreePath rootPath = this.getCategoryTree().getPathForRow(0);
        Object treeNode = rootPath.getLastPathComponent();
        if (treeNode instanceof CategoryTreeRootNode) {
            return (CategoryTreeRootNode)treeNode;
        }
        return null;
    }

    public void selectRootNode() {
        this.getCategoryTree().setSelectionRow(0);
    }

    protected CategoryNodeInterface getNode(TreePath path) {
        Object lastPath;
        if (path != null && CategoryNodeInterface.class.isAssignableFrom((lastPath = path.getLastPathComponent()).getClass())) {
            return (CategoryNodeInterface)lastPath;
        }
        return null;
    }

    public boolean isRootNodeSelected() {
        JTree dataTree = this.getCategoryTree();
        return dataTree.isRowSelected(0);
    }

    public int getSelectionCount() {
        return this.getCategoryTree().getSelectionCount();
    }

    public void selectCurrentCategory() {
        this.selectCurrentNode();
        this.initCategorySelection(this.getFirstSelectedNode());
    }

    public void selectCategory(Category category) {
        TreePath categoryPath = this.getCategoryPath(category);
        if (categoryPath == null) {
            this.selectCurrentCategory();
        } else {
            Object node;
            this.selectNode(categoryPath);
            if (!this.alreadySelected && (node = categoryPath.getLastPathComponent()) instanceof CategoryNodeInterface) {
                this.initCategorySelection((CategoryNodeInterface)node);
            }
        }
    }

    private void selectNode(TreePath categoryPath) {
        this.getCategoryTree().getSelectionModel().setSelectionPath(categoryPath);
    }

    private TreePath getCategoryPath(Category category) {
        TreeModel model = this.getCategoryTree().getModel();
        DefaultNode rootNode = (DefaultNode)model.getRoot();
        Vector<DefaultNode> nodePaths = new Vector<DefaultNode>();
        return this.getCategoryPath(category, nodePaths, rootNode);
    }

    private TreePath getCategoryPath(Category category, Vector<DefaultNode> nodePaths, DefaultNode node) {
        if (node.equals(DefaultMutableTreeNode.EMPTY_ENUMERATION)) {
            return null;
        }
        nodePaths.add(node);
        boolean found = false;
        Category childCategory = null;
        DefaultNode childNode = null;
        List children = node.getChildren();
        int index = 0;
        while (index < children.size()) {
            childNode = (DefaultNode)children.get(index);
            if (childNode instanceof CategoryTreeNode) {
                childCategory = ((CategoryTreeNode)childNode).getNode();
                if (category.getId().equals(childCategory.getId())) {
                    found = true;
                    break;
                }
                TreePath childrenPath = this.getCategoryPath(category, nodePaths, childNode);
                if (childrenPath != null) {
                    return childrenPath;
                }
            }
            nodePaths.remove(childNode);
            ++index;
        }
        if (!found) {
            return null;
        }
        nodePaths.add(childNode);
        return new TreePath(nodePaths.toArray(new Object[0]));
    }

    public void backupExpandedNodes() {
        this.expandedTreePathList = new Vector();
        TreePath rootPath = new TreePath(this.getCategoryTree().getModel().getRoot());
        Enumeration<TreePath> expandedNodes = this.getCategoryTree().getExpandedDescendants(rootPath);
        if (expandedNodes != null) {
            while (expandedNodes.hasMoreElements()) {
                TreePath expPath = expandedNodes.nextElement();
                this.expandedTreePathList.add(expPath);
            }
        }
        this.visibleRectangle = this.getCategoryTree().getVisibleRect();
    }

    protected void printTreePath(TreePath treeNode) {
        if (treeNode == null) {
            return;
        }
        Object[] path = treeNode.getPath();
        System.out.println("CategoryTreeView.printTreePath()");
        System.out.println("path count: " + treeNode.getPathCount() + "  - " + path.length);
        Object[] objectArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            Object pathItem = objectArray[n2];
            if (pathItem instanceof CategoryTreeNode) {
                CategoryTreeNode treenode = (CategoryTreeNode)pathItem;
                System.out.println("pathItem: " + treenode.getNode());
            } else {
                System.out.println("pathItem - raiz: " + ((CategoryTreeRootNode)pathItem).getName());
            }
            ++n2;
        }
    }

    public void restoreExpandedNodes() {
        if (this.expandedTreePathList == null) {
            return;
        }
        for (TreePath oldPath : this.expandedTreePathList) {
            TreePath newPath = this.getNewPath(oldPath);
            if (!this.getCategoryTree().isCollapsed(newPath)) continue;
            this.getCategoryTree().expandPath(newPath);
        }
        this.getCategoryTree().scrollRectToVisible(this.visibleRectangle);
    }

    private TreePath getNewPath(TreePath oldPath) {
        Object[] oldPaths = oldPath.getPath();
        TreeModel model = this.getCategoryTree().getModel();
        if (oldPaths.length == 1) {
            return new TreePath(model.getRoot());
        }
        DefaultNode node = (DefaultNode)model.getRoot();
        Object[] newPaths = new Object[oldPaths.length];
        newPaths[0] = node;
        int i = 1;
        while (i < oldPaths.length) {
            DefaultNode oldNode = (DefaultNode)oldPaths[i];
            List children = node.getChildren();
            if (children.equals(DefaultMutableTreeNode.EMPTY_ENUMERATION)) {
                return null;
            }
            boolean found = false;
            Category oldCategory = null;
            Category childCategory = null;
            DefaultNode childNode = null;
            int index = 0;
            while (index < children.size()) {
                childNode = (DefaultNode)children.get(index);
                if (oldNode instanceof CategoryTreeNode && childNode instanceof CategoryTreeNode) {
                    oldCategory = ((CategoryTreeNode)oldNode).getNode();
                    childCategory = ((CategoryTreeNode)childNode).getNode();
                    if (oldCategory.getId().equals(childCategory.getId())) {
                        found = true;
                        break;
                    }
                }
                if (childNode.toString().equals(oldPaths[i].toString())) {
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                return null;
            }
            node = childNode;
            newPaths[i] = node;
            ++i;
        }
        return new TreePath(newPaths);
    }

    private void initCategorySelection(CategoryNodeInterface node) {
        if (node == null || this.alreadySelected) {
            this.categorySelectionPanel.verifyAndChangeButtonsState();
            return;
        }
        if (this.categorySelectionPanel.isCreationEditionPanel() && !this.categorySelectionPanel.confirmSelectionChanged()) {
            return;
        }
        if (this.changedSelectedCategory()) {
            if (!this.categorySelectionPanel.confirmSelectionChanged()) {
                this.setCurrentNode();
                return;
            }
            this.currentCategoryRow = this.getSelectedRow();
        }
        this.categorySelectionPanel.initCategoryNodeEdition(node);
        this.categorySelectionPanel.verifyAndChangeButtonsState();
    }

    private boolean changedSelectedCategory() {
        return this.currentCategoryRow != this.getSelectedRow();
    }

    private void selectCurrentNode() {
        if (this.currentCategoryRow == -1) {
            this.selectRootNode();
        }
        this.selectNode(this.currentCategoryRow);
    }

    public void selectNode(int row) {
        this.getCategoryTree().setSelectionInterval(row, row);
    }

    public void setCurrentNode() {
        this.alreadySelected = true;
        this.selectCurrentNode();
        this.alreadySelected = false;
    }

    public void updateCategoryTree(SortedSet<Category> nodes) {
        this.setNodes(nodes);
        this.backupExpandedNodes();
        this.categoryTreePanel = this.createDataTreePanel();
        this.restoreExpandedNodes();
    }
}

