/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.AbstractSimpleApplicationPanel;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.AlgorithmsManagerAdapter;
import csbase.client.applications.algorithmsmanager.actions.CommonManagementAction;
import csbase.client.applications.algorithmsmanager.models.DataInterface;
import csbase.client.util.ClientUtilities;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.CategorySet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;

public abstract class CommonSelectionPanel
extends AbstractSimpleApplicationPanel<AlgorithmsManager> {
    private CommonManagementAction action;
    private List<Action> operationActions;

    public CommonSelectionPanel(CommonManagementAction action) {
        super((AlgorithmsManager)action.getApplication());
        this.action = action;
        this.operationActions = this.buildOperationActions();
        this.buildPanel();
        ((AlgorithmsManager)action.getApplication()).addAlgorithmsManagerListener(new AlgorithmsManagerAdapter(){

            @Override
            public void categoryUpdated(CategorySet modifiedCategorySet) {
                CommonSelectionPanel.this.handleCategoryUpdated(modifiedCategorySet);
            }

            @Override
            public void categoryRemoved(Category category) {
                CommonSelectionPanel.this.handleCategoryRemoved(category);
            }

            @Override
            public void categoryCreated(Category category) {
                CommonSelectionPanel.this.handleCategoryCreated(category);
            }

            @Override
            public void algorithmCreated(AlgorithmInfo algoInfo) {
                CommonSelectionPanel.this.handleAlgorithmCreated(algoInfo);
            }

            @Override
            public void algorithmRemoved(AlgorithmInfo algoInfo) {
                CommonSelectionPanel.this.handleAlgorithmRemoved(algoInfo);
            }

            @Override
            public void algorithmUpdated(AlgorithmInfo algoInfo) {
                CommonSelectionPanel.this.handleAlgorithmUpdated(algoInfo);
            }
        });
    }

    protected void handleCategoryCreated(Category category) {
    }

    protected void handleCategoryRemoved(Category category) {
    }

    protected void handleCategoryUpdated(CategorySet modifiedCategorySet) {
    }

    protected void handleAlgorithmUpdated(AlgorithmInfo algoInfo) {
    }

    protected void handleAlgorithmCreated(AlgorithmInfo algoInfo) {
    }

    protected void handleAlgorithmRemoved(AlgorithmInfo algoInfo) {
    }

    protected abstract JPanel buildMainSelectionPanel();

    protected abstract List<Action> buildOperationActions();

    public abstract List<DataInterface> getSelectedDataList();

    protected abstract boolean confirmSelectionChanged();

    public DataInterface getSelectedData() {
        List<DataInterface> selectedDataList = this.getSelectedDataList();
        if (selectedDataList != null && !selectedDataList.isEmpty()) {
            return selectedDataList.get(0);
        }
        return null;
    }

    protected CommonManagementAction getManagementAction() {
        return this.action;
    }

    @Override
    protected void buildPanel() {
        this.setLayout(new GridBagLayout());
        JPanel mainPanel = this.buildMainSelectionPanel();
        JPanel operationPanel = this.getOperationPanel();
        this.add((Component)mainPanel, new GBC(0, 0).both().insets(5, 5, 5, 5));
        this.add((Component)operationPanel, new GBC(0, 1).horizontal().southwest().insets(5, 5, 5, 5));
    }

    private JPanel getOperationPanel() {
        JPanel operationPanel = new JPanel(new GridBagLayout());
        List<JComponent> buttons = this.buildButtons();
        int x = 0;
        int y = 0;
        for (JComponent button : buttons) {
            operationPanel.add((Component)button, new GBC(x++, y).none().west().insets(5, 5, 5, 5));
        }
        ClientUtilities.adjustEqualSizes(buttons.toArray(new JComponent[0]));
        return operationPanel;
    }

    private List<JComponent> buildButtons() {
        ArrayList<JComponent> buttons = new ArrayList<JComponent>();
        for (Action opAction : this.operationActions) {
            buttons.add(this.getOperationButton(opAction));
        }
        return buttons;
    }

    private JComponent getOperationButton(Action opAction) {
        JButton button = new JButton(opAction);
        button.setToolTipText((String)opAction.getValue("ShortDescription"));
        return button;
    }

    protected void enableAction(Action opAction, boolean state) {
        opAction.setEnabled(state);
    }
}

