/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.algorithmsmanager.dialogs.VersionTreeView;
import csbase.client.applications.algorithmsmanager.models.AbstractVersionTreeNode;
import csbase.client.applications.algorithmsmanager.versiontree.VersionNodeInterface;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTreeNode;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.util.Vector;
import javax.swing.ImageIcon;

public final class VersionTreeRootNode
extends AbstractVersionTreeNode
implements VersionNodeInterface {
    private Vector<AlgorithmVersionInfo> allNodes;

    public VersionTreeRootNode(VersionTree tree, Vector<AlgorithmVersionInfo> versions) {
        super(tree, VersionTreeView.ROOT_NAME);
        this.allNodes = versions;
        if (versions != null) {
            for (AlgorithmVersionInfo algoVersion : this.allNodes) {
                this.add(new VersionTreeNode(tree, algoVersion));
            }
        }
    }

    @Override
    public int compare(AlgorithmVersionInfo node) {
        return 0;
    }

    @Override
    public AlgorithmVersionInfo getNode() {
        return null;
    }

    @Override
    public AlgorithmVersionId getId() {
        return null;
    }

    @Override
    public boolean isRootNode() {
        return true;
    }

    @Override
    public ImageIcon getImageIcon() {
        return ApplicationImages.ICON_FOLDER_16;
    }

    public int getNodeIndex(Object algoId) {
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                VersionTreeNode childNode = (VersionTreeNode)this.children.get(i);
                AlgorithmVersionInfo childAlgoInfo = (AlgorithmVersionInfo)childNode.getUserObject();
                AlgorithmVersionId childAlgoId = childAlgoInfo.getId();
                if (algoId.equals(childAlgoId)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }
}

