/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.AbstractImportFileAction;
import csbase.client.desktop.Task;
import csbase.client.externalresources.ExternalResources;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.ClientRemoteLocator;
import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class ImportExecutableFile
extends AbstractImportFileAction {
    private AlgorithmVersionInfo version;
    private String platformName;
    private String destPlataformPath;

    public ImportExecutableFile(VersionTree tree, AlgorithmVersionInfo version, String platformName) {
        super(tree, LNG.get((String)"algomanager.menu.bin_file.add"), 2, true);
        this.version = version;
        this.platformName = platformName;
    }

    public ImportExecutableFile(VersionTree tree, AlgorithmVersionInfo version, String platformName, String destPlataformPath) {
        this(tree, version, platformName);
        this.destPlataformPath = destPlataformPath;
    }

    @Override
    protected Task<Boolean> createCheckFileExistenceTask(String fileName) {
        return null;
    }

    @Override
    protected RemoteFileChannelInfo prepareUpload(String fileName, boolean isZipLocalFile) throws RemoteException {
        AlgorithmInfo algorithm = this.version.getInfo();
        return ClientRemoteLocator.algorithmService.prepareUploadExecFile((Object)algorithm.getId(), (Object)this.version.getId(), this.platformName, this.getFileNameDestPath(fileName), isZipLocalFile);
    }

    private String getFileNameDestPath(String fileName) {
        if (this.destPlataformPath == null) {
            return fileName;
        }
        return String.valueOf(this.destPlataformPath) + File.separator + fileName;
    }

    @Override
    protected void appletUpload() {
        new UploadExecutableDialog().show();
    }

    private class UploadExecutableDialog {
        private String dialogTitle;

        public UploadExecutableDialog() {
            List execs = ImportExecutableFile.this.version.getExecutables(ImportExecutableFile.this.platformName);
            if (execs == null) {
                return;
            }
            Collections.sort(execs);
            this.dialogTitle = MessageFormat.format(LNG.get((String)"algomanager.title.executable"), ImportExecutableFile.this.version.getInfo().getName(), ImportExecutableFile.this.version.getId(), ImportExecutableFile.this.platformName);
        }

        public void show() {
            if (ExternalResources.getInstance().isEnabled()) {
                String addr = AlgorithmManagementProxy.getExecutableURL(ImportExecutableFile.this.version.getInfo().getId(), ImportExecutableFile.this.version.getId(), ImportExecutableFile.this.platformName, ImportExecutableFile.this.getWindow());
                if (addr == null) {
                    return;
                }
                try {
                    URL url = new URL(addr);
                    ExternalResources.getInstance().showDocument(url);
                }
                catch (Exception ex) {
                    StandardErrorDialogs.showErrorDialog(ImportExecutableFile.this.getWindow(), this.dialogTitle, LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_IO_ERROR"), ex);
                }
            } else {
                StandardDialogs.showInfoDialog((Component)ImportExecutableFile.this.getWindow(), (String)this.dialogTitle, (Object)LNG.get((String)"algomanager.error.upload_not_available"));
            }
        }
    }
}

