/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.algorithms.commands.cache.events.AbstractCommandUpdatedEventListener;
import csbase.client.algorithms.commands.cache.events.CommandUpdatedEvent;
import csbase.client.applications.Application;
import csbase.client.applications.commandsmonitor.MonitorFrame;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.srvproxies.SGAProxy;
import csbase.client.util.ClientUtilities;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.SwingThreadDispatcher;
import tecgraf.javautils.gui.table.SortableTable;

public class CommandDetailsFrame
extends DesktopComponentFrame
implements MonitorFrame {
    private static final Lock showCommandDetailsFrameLock = new ReentrantLock();
    private final Application callerApp;
    private final Object projectId;
    private final String commandId;
    private final String sgaName;
    private CommandInfo commandInfo;
    private DynamicInfoPanel dynamicInfoPanel;
    private JButton cancelButton;

    private CommandDetailsFrame(Object projectId, String cmdId, String sgaName, Application app) {
        super(CommandDetailsFrame.createDesktopComponentFrameIndex(cmdId), app.getApplicationFrame(), app.getString("CommandDetailsFrame.title"));
        this.callerApp = app;
        this.setDefaultCloseOperation(2);
        this.projectId = projectId;
        this.commandId = cmdId;
        this.sgaName = sgaName;
        this.initialize();
    }

    public static final void showCommandDetailsFrame(Object projectId, String cmdId, String sgaName, Application app) {
        String index = CommandDetailsFrame.createDesktopComponentFrameIndex(cmdId);
        CommandDetailsFrame commandDetailsFrame = (CommandDetailsFrame)CommandDetailsFrame.getDesktopComponentFrame(index);
        if (commandDetailsFrame == null) {
            showCommandDetailsFrameLock.lock();
            try {
                commandDetailsFrame = (CommandDetailsFrame)CommandDetailsFrame.getDesktopComponentFrame(index);
                if (commandDetailsFrame == null) {
                    commandDetailsFrame = new CommandDetailsFrame(projectId, cmdId, sgaName, app);
                    class WindowCloser
                    extends WindowAdapter {
                        CommandDetailsFrame commandDetailsFrame;
                        private final /* synthetic */ String val$index;

                        WindowCloser(CommandDetailsFrame commandDetailsFrame, String string) {
                            this.val$index = string;
                            this.commandDetailsFrame = commandDetailsFrame;
                        }

                        @Override
                        public void windowClosed(WindowEvent e) {
                            this.commandDetailsFrame.stop();
                            CommandDetailsFrame.removeDesktopComponentFrame(this.val$index);
                        }
                    }
                    commandDetailsFrame.addWindowListener(new WindowCloser(commandDetailsFrame, index));
                }
            }
            finally {
                showCommandDetailsFrameLock.unlock();
            }
        }
        commandDetailsFrame.display();
    }

    public void stop() {
        this.dynamicInfoPanel.stop();
    }

    private void initialize() {
        this.loadCommandInfo();
        this.createGUIComponents();
        this.display();
    }

    private boolean loadCommandInfo() {
        RemoteTask<CommandInfo> task = new RemoteTask<CommandInfo>(){

            protected void performTask() throws Exception {
                CommandInfo newCommandInfo = CommandsCache.getInstance().getCommand(CommandDetailsFrame.this.projectId, CommandDetailsFrame.this.commandId);
                this.setResult(newCommandInfo);
            }
        };
        if (!task.execute(this, this.getTitle(), this.getString("CommandDetailsFrame.msg.loadCommand"))) {
            return false;
        }
        if (task.getResult() == null) {
            String msg = MessageFormat.format(this.getString("CommandDetailsFrame.error.comm_sga"), this.sgaName);
            String title = this.getTitle();
            StandardDialogs.showErrorDialog((Component)this, (String)title, (String)msg);
        }
        this.commandInfo = (CommandInfo)task.getResult();
        return true;
    }

    private void display() {
        this.pack();
        this.center(this.callerApp.getApplicationFrame());
        this.setVisible(true);
    }

    private void createGUIComponents() {
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout(5, 5));
        this.dynamicInfoPanel = new DynamicInfoPanel();
        cp.add((Component)this.dynamicInfoPanel, "Center");
        this.dynamicInfoPanel.start();
        cp.add((Component)this.createButtonsPanel(), "South");
    }

    private JPanel createButtonsPanel() {
        JPanel bp = new JPanel(new FlowLayout());
        JButton closeButton = new JButton(this.getString("CommandDetailsFrame.close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                CommandDetailsFrame.this.close();
            }
        });
        this.cancelButton = new JButton(this.getString("CommandDetailsFrame.cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int res;
                String msg = String.valueOf(CommandDetailsFrame.this.getString("CommandDetailsFrame.cancel.confirm")) + "\n" + MessageFormat.format(CommandDetailsFrame.this.getString("CommandDetailsFrame.cancel.details"), CommandDetailsFrame.this.commandInfo.getTip(), CommandDetailsFrame.this.sgaName);
                String descr = CommandDetailsFrame.this.commandInfo.getDescription();
                if (descr != null && descr.length() > 0) {
                    msg = String.valueOf(msg) + MessageFormat.format(CommandDetailsFrame.this.getString("CommandDetailsFrame.cancel.description"), descr);
                }
                if ((res = StandardDialogs.showYesNoDialog((Component)CommandDetailsFrame.this, (String)CommandDetailsFrame.this.getTitle(), (Object)msg)) == 0) {
                    SGAProxy.killCommand(CommandDetailsFrame.this.sgaName, CommandDetailsFrame.this.commandId);
                }
            }
        });
        this.cancelButton.setEnabled(this.commandInfo.getStatus() != CommandStatus.FINISHED);
        ClientUtilities.adjustEqualSizes(this.cancelButton, closeButton);
        bp.add(this.cancelButton);
        bp.add(closeButton);
        return bp;
    }

    protected final String getString(String key) {
        return this.callerApp.getString(key);
    }

    private static String createDesktopComponentFrameIndex(Object cmdId) {
        return "CommandDetailsFrame_" + cmdId;
    }

    private class CommandDetailsTable
    extends SortableTable {
        private static final String DOTTED = "------";
        protected DefaultTableModel model;
        private int statusRow = -1;
        private int etimeRow = -1;

        CommandDetailsTable() {
            this.model = new DefaultTableModel(new Object[]{CommandDetailsFrame.this.getString("CommandDetailsFrame.details.key"), CommandDetailsFrame.this.getString("CommandDetailsFrame.details.value")}, 0);
            this.setModel(this.model);
            this.setPreferredScrollableViewportSize(new Dimension(300, 150));
        }

        String getPercString(Double value) {
            if (value == null) {
                return DOTTED;
            }
            return String.valueOf(value.intValue()) + " %";
        }

        String getWallTimeString(Integer value) {
            if (value == null) {
                return DOTTED;
            }
            return FormatUtils.formatInterval((int)value);
        }

        void addNewRow(String key, String value) {
            this.model.addRow(new Object[]{key, value});
        }

        void updateDynamicInfo() {
            this.model.setRowCount(0);
            String status = CommandDetailsFrame.this.commandInfo.isValid() ? (CommandDetailsFrame.this.commandInfo.isQueued() ? CommandDetailsFrame.this.getString("CommandDetailsFrame.queued") : CommandDetailsFrame.this.getString("CommandDetailsFrame.status." + CommandDetailsFrame.this.commandInfo.getStatus())) : CommandDetailsFrame.this.getString("CommandDetailsFrame.disconnected");
            this.addNewRow(CommandDetailsFrame.this.getString("CommandDetailsFrame.status"), status);
            this.statusRow = 0;
            this.addNewRow(CommandDetailsFrame.this.getString("CommandDetailsFrame.time.elapsed"), this.getWallTimeString(CommandDetailsFrame.this.commandInfo.getWallTimeSec()));
            this.etimeRow = 1;
            this.addNewRow(CommandDetailsFrame.this.getString("CommandDetailsFrame.cpu.usage"), this.getPercString(CommandDetailsFrame.this.commandInfo.getCpuPerc()));
            this.addNewRow(CommandDetailsFrame.this.getString("CommandDetailsFrame.ram.usage"), this.getPercString(CommandDetailsFrame.this.commandInfo.getRAMMemoryPerc()));
            this.addNewRow(CommandDetailsFrame.this.getString("CommandDetailsFrame.swap.usage"), this.getPercString(CommandDetailsFrame.this.commandInfo.getSwapMemoryPerc()));
            Map allInfo = CommandDetailsFrame.this.commandInfo.getSpecificData();
            if (allInfo != null && allInfo.size() > 0) {
                for (String key : allInfo.keySet()) {
                    this.addNewRow(key, (String)allInfo.get(key));
                }
            }
        }

        void noDynamicInfo() {
            int nlines = this.model.getRowCount();
            int row = 0;
            while (row < nlines) {
                if (row != this.statusRow) {
                    this.model.setValueAt(DOTTED, row, 1);
                }
                ++row;
            }
        }

        void commandFinished(CommandUpdatedEvent.Type type, CommandInfo cmd) {
            this.noDynamicInfo();
            if (this.statusRow < 0) {
                return;
            }
            String returnValue = CommandDetailsFrame.this.getString("CommandDetailsFrame.status.FINISHED");
            switch (type) {
                case end: 
                case removed: {
                    this.setEndTime(cmd);
                    break;
                }
                case success: {
                    this.setEndTime(cmd);
                    returnValue = String.valueOf(returnValue) + " (" + CommandDetailsFrame.this.getString("CommandDetailsFrame.command.end.success") + ")";
                    break;
                }
                case error: {
                    returnValue = String.valueOf(returnValue) + " (" + CommandDetailsFrame.this.getString("CommandDetailsFrame.command.end.error") + ")";
                    break;
                }
                case failed: {
                    returnValue = String.valueOf(returnValue) + " (" + CommandDetailsFrame.this.getString("CommandDetailsFrame.command.end.failure") + ")";
                    break;
                }
                case killed: {
                    returnValue = String.valueOf(returnValue) + " (" + CommandDetailsFrame.this.getString("CommandDetailsFrame.command.end.killed") + ")";
                    break;
                }
                case lost: {
                    returnValue = String.valueOf(returnValue) + " (" + CommandDetailsFrame.this.getString("CommandDetailsFrame.command.end.lost") + ")";
                    break;
                }
                case no_code: {
                    returnValue = String.valueOf(returnValue) + " (" + CommandDetailsFrame.this.getString("CommandDetailsFrame.command.end.no_code") + ")";
                }
            }
            this.model.setValueAt(returnValue, this.statusRow, 1);
        }

        private void setEndTime(CommandInfo cmd) {
            if (this.etimeRow >= 0) {
                int wallTime = cmd.getWallTimeSec();
                String sWallTime = this.getWallTimeString(wallTime);
                this.model.setValueAt(sWallTime, this.etimeRow, 1);
            }
        }
    }

    private class DynamicInfoPanel
    extends JPanel {
        private final AtomicBoolean running;
        JTextField tipText;
        JTextField descriptionText;
        JTextField serverText;
        CommandDetailsTable detailsTable;
        AbstractCommandUpdatedEventListener listener;

        public DynamicInfoPanel() {
            super(new GridBagLayout());
            this.running = new AtomicBoolean(false);
            this.listener = new AbstractCommandUpdatedEventListener(CommandDetailsFrame.this.commandInfo.getProjectId(), CommandDetailsFrame.this.commandInfo.getId()){

                @Override
                protected void eventFired(final CommandUpdatedEvent.Type type, final CommandInfo cmd) {
                    CommandDetailsFrame.this.getStatusBar().hideStatusBar();
                    switch (type) {
                        case end: 
                        case error: 
                        case success: 
                        case failed: 
                        case killed: 
                        case lost: 
                        case removed: 
                        case no_code: {
                            SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    DynamicInfoPanel.this.stop();
                                    CommandDetailsFrame.this.cancelButton.setEnabled(false);
                                    (this).DynamicInfoPanel.this.detailsTable.commandFinished(type, cmd);
                                }
                            });
                            break;
                        }
                        default: {
                            CommandDetailsFrame.this.commandInfo = cmd;
                            SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CommandDetailsFrame.this.dynamicInfoPanel.updateInfo();
                                }
                            });
                        }
                    }
                }

                @Override
                protected void eventInterrupted(Exception exception, String description) {
                    CommandDetailsFrame.this.getStatusBar().setError(description);
                }
            };
            this.createGUIComponents();
        }

        private void updateInfo() {
            if (CommandDetailsFrame.this.commandInfo == null) {
                this.detailsTable.noDynamicInfo();
                return;
            }
            this.tipText.setText(CommandDetailsFrame.this.commandInfo.getTip());
            this.descriptionText.setText(CommandDetailsFrame.this.commandInfo.getDescription());
            this.serverText.setText(CommandDetailsFrame.this.commandInfo.getSGAName());
            this.detailsTable.updateDynamicInfo();
        }

        public synchronized void start() {
            if (this.running.compareAndSet(false, true)) {
                CommandsCache.getInstance().addEventListener(this.listener);
            }
        }

        public synchronized void stop() {
            if (this.running.compareAndSet(true, false)) {
                CommandsCache.getInstance().removeEventListener(this.listener);
            }
        }

        private void createGUIComponents() {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            JLabel tipLabel = new JLabel(String.valueOf(CommandDetailsFrame.this.getString("CommandDetailsFrame.command")) + ":");
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.fill = 0;
            constraints.insets = new Insets(12, 12, 0, 0);
            this.add((Component)tipLabel, constraints);
            this.tipText = new JTextField();
            this.tipText.setEditable(false);
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.fill = 2;
            constraints.insets = new Insets(12, 6, 0, 11);
            this.add((Component)this.tipText, constraints);
            JLabel descriptionLabel = new JLabel(String.valueOf(CommandDetailsFrame.this.getString("CommandDetailsFrame.description")) + ":");
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.fill = 0;
            constraints.insets = new Insets(6, 12, 0, 0);
            this.add((Component)descriptionLabel, constraints);
            this.descriptionText = new JTextField();
            this.descriptionText.setEditable(false);
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.fill = 2;
            constraints.insets = new Insets(6, 6, 0, 11);
            this.add((Component)this.descriptionText, constraints);
            JLabel serverLabel = new JLabel(String.valueOf(CommandDetailsFrame.this.getString("CommandDetailsFrame.server")) + ":");
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.fill = 0;
            constraints.insets = new Insets(6, 12, 0, 0);
            this.add((Component)serverLabel, constraints);
            this.serverText = new JTextField();
            this.serverText.setEditable(false);
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.fill = 2;
            constraints.insets = new Insets(6, 6, 0, 11);
            this.add((Component)this.serverText, constraints);
            JLabel detailsLabel = new JLabel(String.valueOf(CommandDetailsFrame.this.getString("CommandDetailsFrame.details")) + ":");
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 2;
            constraints.fill = 0;
            constraints.insets = new Insets(6, 12, 0, 11);
            this.add((Component)detailsLabel, constraints);
            this.detailsTable = new CommandDetailsTable();
            constraints.gridx = 0;
            constraints.gridy = 4;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            constraints.insets = new Insets(6, 12, 0, 11);
            this.add((Component)new JScrollPane((Component)((Object)this.detailsTable)), constraints);
            this.updateInfo();
        }
    }
}

