/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.commandsmonitor.JTabbedPaneSelectionListener;
import csbase.client.applications.commandsmonitor.TablesTab;
import csbase.client.applications.commandsmonitor.dal.ITablesTabDAO;
import csbase.client.applications.commandsmonitor.models.TablesTabDTO;
import csbase.client.applications.commandsmonitor.table.CommandsTableFactory;
import csbase.client.util.event.EventManager;
import csbase.client.util.gui.ComponentUtilities;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Component;
import java.util.List;
import javax.swing.JTabbedPane;

public class TablesTabbedPane
extends JTabbedPane {
    public TablesTabbedPane(ITablesTabDAO tabsDS, CommandsTableFactory tablesFactory, ApplicationRegistry appRegistry, EventManager eventManager) throws ApplicationException {
        this.addChangeListener(new JTabbedPaneSelectionListener());
        this.createUI(tabsDS, tablesFactory, appRegistry, eventManager);
    }

    public void start() {
        Component tab = this.getSelectedComponent();
        if (tab != null && TablesTab.class.isAssignableFrom(tab.getClass())) {
            ((TablesTab)TablesTab.class.cast(tab)).start();
        }
    }

    public void stop() {
        int inx = 0;
        while (inx < this.getTabCount()) {
            Component component = this.getTabComponentAt(inx);
            if (component instanceof TablesTab) {
                ((TablesTab)TablesTab.class.cast(component)).stop();
            }
            ++inx;
        }
    }

    private void createUI(ITablesTabDAO tabsDS, CommandsTableFactory tablesFactory, ApplicationRegistry appRegistry, EventManager eventManager) throws ApplicationException {
        List<TablesTabDTO> tabsInfo = tabsDS.getTabsInfo();
        Component[] tabs = new TablesTab[tabsInfo.size()];
        int inx = 0;
        while (inx < tabsInfo.size()) {
            TablesTabDTO aTabInfo = tabsInfo.get(inx);
            tabs[inx] = new TablesTab(aTabInfo, tablesFactory, appRegistry, eventManager);
            this.addTab(((TablesTab)tabs[inx]).getTitle(), tabs[inx]);
            if (((TablesTab)tabs[inx]).getId().equals(tabsDS.getSelectedTabId())) {
                this.setSelectedComponent(tabs[inx]);
            }
            ++inx;
        }
        this.getPreferredSize().width = ComponentUtilities.getMaxPreferredSize((Component[])tabs).width + 100;
    }
}

