/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor.table;

import csbase.client.algorithms.commands.cache.CommandsFilter;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.commandsmonitor.dal.ICommandsTableDAO;
import csbase.client.applications.commandsmonitor.models.ColumnDTO;
import csbase.client.applications.commandsmonitor.models.CommandsFilterDTO;
import csbase.client.applications.commandsmonitor.models.CommandsTableDTO;
import csbase.client.applications.commandsmonitor.models.ExpressionDTO;
import csbase.client.applications.commandsmonitor.table.CommandsTableProvider;
import csbase.client.applications.commandsmonitor.table.column.AbstractCommandsTableColumn;
import csbase.client.applications.commandsmonitor.table.script.ScriptCommand;
import csbase.client.facilities.commandtable.AbstractCommandMonitoringTable;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class CommandsTableFactory {
    private ApplicationRegistry applicationRegistry;
    private Map<String, ColumnDTO> columnsInfoById;
    private Map<String, CommandsTableDTO> tablesInfoById;
    private Map<String, CommandsFilter> filtersById;

    public CommandsTableFactory(ApplicationRegistry applicationRegistry, ICommandsTableDAO dataSource) {
        this.applicationRegistry = applicationRegistry;
        this.columnsInfoById = new HashMap<String, ColumnDTO>();
        this.tablesInfoById = new HashMap<String, CommandsTableDTO>();
        this.filtersById = new HashMap<String, CommandsFilter>();
        Set<ColumnDTO> columnsInfo = dataSource.getColumnsInfo();
        for (ColumnDTO aColumnInfo : columnsInfo) {
            this.columnsInfoById.put(aColumnInfo.getId(), aColumnInfo);
        }
        Set<CommandsTableDTO> tablesInfo = dataSource.getTablesInfo();
        for (CommandsTableDTO aTableInfo : tablesInfo) {
            this.tablesInfoById.put(aTableInfo.getId(), aTableInfo);
        }
        Set<CommandsFilterDTO> filtersInfo = dataSource.getFiltersInfo();
        for (CommandsFilterDTO aFilterInfo : filtersInfo) {
            CommandsFilter filter = this.createFilter(aFilterInfo);
            this.filtersById.put(aFilterInfo.getId(), filter);
        }
    }

    public Set<String> getTablesId() {
        return this.tablesInfoById.keySet();
    }

    public AbstractCommandMonitoringTable createTable(String id) throws ApplicationException {
        Long cellsEditingMinTime;
        CommandsTableDTO tableInfo = this.tablesInfoById.get(id);
        if (tableInfo == null) {
            throw new IllegalArgumentException("Unknown table identifier. Table id: " + id);
        }
        CommandsFilter filter = this.filtersById.get(tableInfo.getFilterId());
        if (filter == null) {
            throw new IllegalArgumentException("Unknown filter identifier. Table id: " + id + ", filter id: " + tableInfo.getFilterId());
        }
        int oderbyColumnIndex = -1;
        ArrayList<AbstractCommandsTableColumn> columns = new ArrayList<AbstractCommandsTableColumn>();
        int index = 0;
        while (index < tableInfo.getColumnsId().size()) {
            String columnId = tableInfo.getColumnsId().get(index);
            columns.add(this.createColumn(columnId));
            if (columnId.equals(tableInfo.getOrderby())) {
                oderbyColumnIndex = index;
            }
            ++index;
        }
        CommandsTableProvider provider = new CommandsTableProvider(columns);
        AbstractCommandMonitoringTable table = new AbstractCommandMonitoringTable(2, filter, (ObjectTableProvider)provider, columns){
            private final /* synthetic */ ObjectTableProvider val$provider;
            private final /* synthetic */ List val$columns;
            {
                this.val$provider = objectTableProvider;
                this.val$columns = list;
                super($anonymous0, $anonymous1);
            }

            @Override
            protected ObjectTableProvider getObjectTableProvider() {
                return this.val$provider;
            }

            @Override
            protected TableCellRenderer createTableCellRenderer(int columnIndex) {
                return ((AbstractCommandsTableColumn)this.val$columns.get(columnIndex)).createTableCellRenderer();
            }

            @Override
            protected TableCellEditor createTableCellEditor(int columnIndex) {
                return ((AbstractCommandsTableColumn)this.val$columns.get(columnIndex)).createTableCellEditor();
            }
        };
        TableColumnModel columnsModel = table.getColumnModel();
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int inx = 0;
        while (inx < table.getColumnCount()) {
            String columnName = table.getColumnName(inx);
            Component header = headerRenderer.getTableCellRendererComponent((JTable)((Object)table), columnName, false, false, 0, inx);
            int width = header.getPreferredSize().width;
            TableColumn aColumnModel = columnsModel.getColumn(inx);
            aColumnModel.setPreferredWidth(width);
            ++inx;
        }
        if (oderbyColumnIndex >= 0) {
            SortOrder order = tableInfo.isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING;
            table.sort(oderbyColumnIndex, order);
        }
        if ((cellsEditingMinTime = tableInfo.getCellsEditingMinTime()) != null) {
            table.setCellsEditingMinTime(tableInfo.getCellsEditingMinTime());
        }
        return table;
    }

    public AbstractCommandsTableColumn createColumn(String id) throws ApplicationException {
        if (id == null) {
            throw new NullPointerException("id");
        }
        try {
            if (!this.columnsInfoById.containsKey(id)) {
                throw new ClassNotFoundException("Unknown classe for column " + id);
            }
            ColumnDTO info = this.columnsInfoById.get(id);
            Class<?> clazz = Class.forName(info.getColumnClassName());
            Constructor<?> constructor = clazz.getConstructor(String.class, ApplicationRegistry.class);
            AbstractCommandsTableColumn column = (AbstractCommandsTableColumn)constructor.newInstance(id, this.applicationRegistry);
            return column;
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
    }

    private CommandsFilter createFilter(CommandsFilterDTO filterInfo) {
        boolean in = filterInfo.areStatusesIncluded();
        CommandStatus[] statuses = filterInfo.getStatuses();
        final ExpressionDTO expressionInfo = filterInfo.getExpressionInfo();
        if (expressionInfo == null) {
            return new CommandsFilter(in, statuses);
        }
        CommandsFilter filter = new CommandsFilter(in, statuses){
            ScriptEngineManager manager;
            ScriptEngine engine;
            {
                super($anonymous0, $anonymous1);
                this.manager = new ScriptEngineManager();
                this.engine = this.manager.getEngineByName(expressionDTO.getLanguage());
            }

            @Override
            protected boolean acceptCommand(CommandInfo cmd) {
                SimpleScriptContext context = new SimpleScriptContext();
                Bindings engineScope = context.getBindings(100);
                engineScope.put("command", (Object)new ScriptCommand(cmd));
                try {
                    return (Boolean)this.engine.eval(expressionInfo.getValue(), (ScriptContext)context);
                }
                catch (ScriptException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        };
        return filter;
    }
}

