/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.desktoplauncher;

import csbase.client.Client;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationHideAction;
import csbase.client.applications.desktoplauncher.DesktopLauncherEvent;
import csbase.client.applications.desktoplauncher.DesktopLauncherEventHandler;
import csbase.client.applications.desktoplauncher.DesktopLauncherTask;
import csbase.client.applications.desktoplauncher.actions.ClearLogAction;
import csbase.client.applications.desktoplauncher.actions.DesktopHideAction;
import csbase.client.applications.desktoplauncher.actions.DesktopShowAction;
import csbase.client.applications.desktoplauncher.actions.DesktopShutdownAction;
import csbase.client.applications.desktoplauncher.panels.eventpanel.EventPanel;
import csbase.client.applications.desktoplauncher.panels.logpanel.LogPanel;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.externalresources.ExternalResources;
import csbase.logic.User;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class DesktopLauncher
extends Application {
    private DesktopLauncherEventHandler eventHandler;
    private final String sonId;
    private final EventPanel eventPanel = new EventPanel(this);
    private final LogPanel logPanel = new LogPanel(this);

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.buildOptionsMenu());
        menuBar.add(this.buildDesktopMenu());
        return menuBar;
    }

    private JMenu buildOptionsMenu() {
        JMenu menu = new JMenu(this.getString("options.menu"));
        menu.add(new ClearLogAction(this));
        menu.add(new ApplicationHideAction(this));
        menu.addSeparator();
        menu.add(new ApplicationExitAction(this));
        return menu;
    }

    private JMenu buildDesktopMenu() {
        JMenu menu = new JMenu(this.getString("desktop.menu"));
        menu.add(new DesktopHideAction(this));
        menu.add(new DesktopShowAction(this));
        menu.addSeparator();
        menu.add(new DesktopShutdownAction(this));
        return menu;
    }

    private JToolBar buildToolBar() {
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(new ClearLogAction(this));
        toolBar.add(new ApplicationHideAction(this));
        toolBar.addSeparator();
        toolBar.add(new DesktopHideAction(this));
        toolBar.add(new DesktopShowAction(this));
        toolBar.add(new DesktopShutdownAction(this));
        toolBar.addSeparator();
        return toolBar;
    }

    protected void addLauncherEvent(final DesktopLauncherEvent ev) {
        Client client = Client.getInstance();
        String myId = client.getClientInstanceId();
        if (ev.getOtherId().equals(myId)) {
            return;
        }
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DesktopLauncher.this.eventPanel.addLauncherEvent(ev);
            }
        });
    }

    protected void clearLauncherEvents() {
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DesktopLauncher.this.eventPanel.clearLauncherEvents();
            }
        });
    }

    final String getInitialApplicationId() {
        String propName = "initial.application.id";
        String appId = this.getStringSpecificProperty("initial.application.id");
        if (appId.equals("null")) {
            return null;
        }
        return appId;
    }

    final String getInitialProjectId() {
        String propName = "initial.project.id";
        String projId = this.getStringSpecificProperty("initial.project.id");
        if (projId.equals("null")) {
            return null;
        }
        User loggedUser = User.getLoggedUser();
        projId = projId.replaceAll("\\$LOGIN", loggedUser.getLogin());
        return projId;
    }

    public final boolean isInitalApplicationProjectDependent() {
        String propName = "initial.application.requires.project";
        boolean appDep = this.getBooleanSpecificProperty("initial.application.requires.project", false);
        return appDep;
    }

    public final boolean isChildDesktopInitiallyVisible() {
        String propName = "child.desktop.visible";
        boolean appDep = this.getBooleanSpecificProperty("child.desktop.visible", false);
        return appDep;
    }

    /*
     * Unable to fully structure code
     */
    private DesktopLauncherEventHandler createEventHandler() {
        block5: {
            className = this.getStringSpecificProperty("event.handler.class");
            if (className.equals("null")) {
                err = this.getString("event.handler.explicit.null.message");
                this.log(err);
                return null;
            }
            loadingTag = this.getString("class.loading.message");
            this.log(String.format(loadingTag, new Object[]{className}));
            forNameClass = Class.forName(className);
            castingTag = this.getString("class.casting.message");
            forNameClassName = forNameClass.getName();
            superClass = DesktopLauncherEventHandler.class;
            superClassName = superClass.getName();
            this.log(String.format(castingTag, new Object[]{forNameClassName, superClassName}));
            handlerClass = forNameClass.asSubclass(superClass);
            findingTag = this.getString("constructor.finding.message");
            handlerClassName = handlerClass.getName();
            this.log(String.format(findingTag, new Object[]{handlerClassName}));
            constructor = handlerClass.getDeclaredConstructor(new Class[]{DesktopLauncher.class});
            if (constructor != null) break block5;
            err = this.getString("event.handler.constructor.not.found.message");
            this.log(err);
            return null;
        }
        try {
            this.log("Constructor: " + constructor.toGenericString());
            handler = constructor.newInstance(new Object[]{this});
            return handler;
        }
        catch (Exception e) {
            msg = this.getString("event.handler.constructor.failed.message");
            excpClassName = e.getClass().getSimpleName();
            excpMessage = e.getMessage();
            err = String.valueOf(msg) + " - " + excpClassName + " - " + excpMessage;
            this.log(err);
            this.log(null);
            var11_15 = stackTrace = e.getStackTrace();
            var10_14 = stackTrace.length;
            var9_12 = 0;
            ** while (var9_12 < var10_14)
        }
lbl-1000:
        // 1 sources

        {
            stackTraceElement = var11_15[var9_12];
            this.log("    - " + stackTraceElement.toString());
            ++var9_12;
            continue;
        }
lbl44:
        // 1 sources

        this.log(null);
        return null;
    }

    public final DesktopLauncherEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public final String getSonId() {
        return this.sonId;
    }

    @Override
    public void killApplication() throws ApplicationException {
        try {
            if (this.eventHandler != null) {
                this.eventHandler.shutdown();
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
    }

    @Override
    public void postInitialization() throws ApplicationException {
        String message;
        String title;
        String systemLabel = this.getStringSpecificProperty("system.label");
        if (systemLabel == null) {
            String msg = this.getString("no.system.label.error");
            throw new ApplicationException(msg);
        }
        ExternalResources externalResources = ExternalResources.getInstance();
        if (!externalResources.isEnabled()) {
            String msg = this.getString("no.external.resources.error");
            throw new ApplicationException(msg);
        }
        DesktopLauncherTask connTask = new DesktopLauncherTask(this, systemLabel);
        DesktopFrame desktop = DesktopFrame.getInstance();
        DesktopComponentFrame desktopFrame = desktop.getDesktopFrame();
        boolean executed = connTask.execute(desktopFrame, title = this.getString("connection.title"), message = this.getString("connection.message"));
        if (!executed) {
            Exception exception = connTask.getError();
            throw new ApplicationException(exception);
        }
        this.eventHandler = this.createEventHandler();
        if (this.eventHandler == null) {
            String noHandlerMsg = this.getString("no.event.handler.warning");
            this.log(noHandlerMsg);
            return;
        }
        String handlerMsg = this.getString("event.handler.class.message");
        Class<?> eventHandlerClass = this.eventHandler.getClass();
        String eventHandlerClassName = eventHandlerClass.getName();
        this.log(String.valueOf(handlerMsg) + ": " + eventHandlerClassName);
        this.eventHandler.init();
    }

    @Override
    protected boolean userCanKillApplication() {
        return true;
    }

    public DesktopLauncher(String id) {
        super(id);
        Client client = Client.getInstance();
        this.sonId = client.generateNewSonId();
        ApplicationFrame mainFrame = this.getApplicationFrame();
        this.mountFrame(mainFrame);
        mainFrame.setJMenuBar(this.buildMenuBar());
        mainFrame.setSize(new Dimension(700, 400));
    }

    private void mountFrame(JFrame mainFrame) {
        Client client = Client.getInstance();
        Container contentPane = mainFrame.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        String myId = client.getClientInstanceId();
        JTextField idText = new JTextField();
        idText.setEditable(false);
        idText.setText(myId);
        idText.setHorizontalAlignment(2);
        JToolBar toolBar = this.buildToolBar();
        contentPane.add((Component)toolBar, new GBC(0, 0).horizontal());
        JSplitPane split = new JSplitPane(0, this.eventPanel, this.logPanel);
        split.setOneTouchExpandable(true);
        split.setResizeWeight(0.75);
        contentPane.add((Component)split, new GBC(0, 1).both().weights(2.0, 1.0));
        contentPane.add((Component)idText, new GBC(0, 2).horizontal());
    }

    public final void log(final String text) {
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DesktopLauncher.this.logPanel.appendText(text);
            }
        });
    }

    public LogPanel getLogPanel() {
        return this.logPanel;
    }
}

