/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.fileexchanger.logic;

import csbase.client.applications.fileexchanger.FileExchangerUI;
import csbase.client.applications.fileexchanger.logic.Exchange;
import csbase.client.applications.fileexchanger.logic.ExchangeExport;
import csbase.client.applications.fileexchanger.logic.ExchangeMode;
import csbase.client.applications.fileexchanger.logic.ExchangeThread;
import csbase.exception.project.FileLockedException;
import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileChannelLoadListener;
import csbase.logic.ProjectFileFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;

public class ExchangeExportThread
extends ExchangeThread {
    @Override
    public void run() {
        ExchangeExport exchange = (ExchangeExport)this.getExchange();
        ClientProjectFile remoteFile = exchange.getRemoteFile();
        File localFile = exchange.getLocalFile();
        ExchangeMode transferMode = exchange.getTransferMode();
        ProjectFileFilter filter = exchange.getFilter();
        try {
            if (remoteFile.isDirectory()) {
                exchange.setTotalTransferSize(remoteFile.getTotalSize(filter));
            }
            switch (transferMode) {
                case STREAM: {
                    this.exportAsStream(remoteFile, localFile, filter);
                    break;
                }
                case OPERATION: {
                    this.exportAsDownload(remoteFile, localFile, filter);
                }
            }
        }
        catch (Exception e) {
            exchange.signalEnded(e);
            return;
        }
        exchange.signalEnded(null);
    }

    private void exportAsDownload(ClientProjectFile remoteFile, File localFile, ProjectFileFilter filter) throws FileLockedException, IOException {
        final Exchange exchange = this.getExchange();
        if (remoteFile.isDirectory()) {
            ClientProjectFile[] children;
            this.createDirectory(localFile);
            exchange.addCurrentTransferSize(localFile.length());
            ClientProjectFile[] clientProjectFileArray = children = remoteFile.getLocalChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ClientProjectFile child = clientProjectFileArray[n2];
                String NewNameLocalFile = String.valueOf(localFile.getAbsolutePath()) + File.separator + child.getName();
                if (filter == null || filter.accept(child)) {
                    this.exportAsDownload(child, new File(NewNameLocalFile), filter);
                }
                ++n2;
            }
        } else {
            int chunkSize = exchange.getBlockSize().getSize();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localFile));
            remoteFile.download((OutputStream)out, (long)chunkSize, new ProjectFileChannelLoadListener(){

                public void transferedBytes(long currentSize, long numBytes) {
                    exchange.addCurrentTransferSize(numBytes);
                }
            });
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
    }

    private void exportAsStream(ClientProjectFile remoteFile, File localFile, ProjectFileFilter filter) throws RemoteException, IOException {
        Exchange exchange = this.getExchange();
        if (remoteFile.isDirectory()) {
            ClientProjectFile[] children;
            this.createDirectory(localFile);
            exchange.addCurrentTransferSize(localFile.length());
            ClientProjectFile[] clientProjectFileArray = children = remoteFile.getLocalChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ClientProjectFile child = clientProjectFileArray[n2];
                String NewNameLocalFile = String.valueOf(localFile.getAbsolutePath()) + File.separator + child.getName();
                if (filter == null || filter.accept(child)) {
                    this.exportAsStream(child, new File(NewNameLocalFile), filter);
                }
                ++n2;
            }
        } else {
            int bufferSize = exchange.getBlockSize().getSize();
            InputStream prjStream = remoteFile.getInputStream();
            BufferedInputStream in = new BufferedInputStream(prjStream);
            FileOutputStream fileStream = new FileOutputStream(localFile);
            BufferedOutputStream out = new BufferedOutputStream(fileStream);
            byte[] buffer = new byte[bufferSize];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                exchange.addCurrentTransferSize(len);
                out.write(buffer, 0, len);
            }
            out.flush();
            out.close();
            in.close();
        }
    }

    private boolean createDirectory(File localFile) throws IOException {
        boolean result;
        if (!localFile.exists() && !(result = localFile.mkdir())) {
            Object[] args = new String[]{localFile.getAbsolutePath()};
            String msg = FileExchangerUI.getString("ExchangeExportThread.mkdir.error", args);
            throw new IOException(msg);
        }
        return true;
    }

    public ExchangeExportThread(Exchange exchange) {
        super(exchange);
    }
}

