/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.fileexchanger.panels.tablepanel;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.fileexchanger.FileExchangerUI;
import csbase.client.applications.fileexchanger.logic.BlockSize;
import csbase.client.applications.fileexchanger.logic.Exchange;
import csbase.client.applications.fileexchanger.logic.ExchangeMode;
import csbase.client.applications.fileexchanger.logic.ExchangeState;
import csbase.client.applications.fileexchanger.logic.ExchangeType;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import tecgraf.javautils.core.lng.FormatUtils;

public class TableListRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        label.setIcon(null);
        label.setToolTipText(null);
        label.setText(null);
        label.setForeground(Color.BLACK);
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        if (row < 0) {
            return label;
        }
        if (column == 0) {
            ExchangeType type = (ExchangeType)((Object)value);
            ImageIcon exIcon = ApplicationImages.ICON_EXPORT_16;
            ImageIcon imIcon = ApplicationImages.ICON_IMPORT_16;
            ImageIcon icon = type == ExchangeType.IMPORT ? imIcon : exIcon;
            label.setIcon(icon);
            label.setToolTipText(type.getDescription());
            return label;
        }
        if (column == 1) {
            Exchange exchange = (Exchange)value;
            boolean isDirectory = false;
            if (exchange.getType() == ExchangeType.IMPORT) {
                if (exchange.getLocalFile().isDirectory()) {
                    isDirectory = true;
                }
            } else if (exchange.getType() == ExchangeType.EXPORT && exchange.getRemoteFile().isDirectory()) {
                isDirectory = true;
            }
            ImageIcon icon = null;
            if (isDirectory) {
                icon = ApplicationImages.ICON_FOLDER_16;
                label.setToolTipText(FileExchangerUI.getString("TableListRenderer.directory"));
            } else {
                icon = ApplicationImages.ICON_FILE_16;
                label.setToolTipText(FileExchangerUI.getString("TableListRenderer.file"));
            }
            label.setIcon(icon);
            return label;
        }
        if (column == 2) {
            Exchange exchange = (Exchange)value;
            ExchangeState state = exchange.getState();
            Icon image = state.getImage();
            String toolTipText = state.getDescription();
            if (state == ExchangeState.ERROR && exchange.getException() != null) {
                toolTipText = String.valueOf(toolTipText) + ": " + exchange.getException().getMessage();
            }
            label.setToolTipText(toolTipText);
            label.setIcon(image);
            return label;
        }
        if (column == 3) {
            int n = (Integer)value;
            if ((double)n <= 0.0) {
                label.setText("-");
                return label;
            }
            JProgressBar bar = new JProgressBar();
            bar.setValue(n);
            bar.setStringPainted(true);
            bar.setString(String.valueOf(n) + "%");
            return bar;
        }
        if (column == 4) {
            String path = (String)value;
            label.setText(path);
            label.setHorizontalAlignment(2);
            return label;
        }
        if (column == 5) {
            String path = (String)value;
            label.setText(path);
            label.setHorizontalAlignment(2);
            return label;
        }
        if (column == 6) {
            long remaining = (Long)value;
            label.setText(FileExchangerUI.formatLongTime(remaining));
            label.setHorizontalAlignment(4);
            return label;
        }
        if (column == 7) {
            long elapsed = (Long)value;
            label.setText(FileExchangerUI.formatLongTime(elapsed));
            label.setHorizontalAlignment(4);
            return label;
        }
        if (column == 8) {
            double rate = (Double)value;
            if (rate <= 0.0) {
                label.setText("-");
            } else {
                label.setText(String.valueOf(String.format("%.3f", rate)) + " Mb/s");
            }
            label.setHorizontalAlignment(4);
            return label;
        }
        if (column == 9) {
            double rate = (Double)value;
            if (rate <= 0.0) {
                label.setText("-");
            } else {
                label.setText(String.valueOf(String.format("%.3f", rate)) + " Mb/s");
            }
            label.setHorizontalAlignment(4);
            return label;
        }
        if (column == 10) {
            long size = (Long)value;
            if ((double)size <= 0.0) {
                label.setText("-");
            } else {
                label.setText(FormatUtils.formatSize((long)size, (int)2));
                label.setHorizontalAlignment(4);
            }
            return label;
        }
        if (column == 11) {
            ExchangeMode transferMode = (ExchangeMode)((Object)value);
            label.setText(transferMode.getName());
            label.setHorizontalAlignment(0);
            return label;
        }
        if (column == 12) {
            BlockSize blockSize = (BlockSize)((Object)value);
            label.setText(String.valueOf(blockSize.getSizeKb()) + " KB");
            label.setHorizontalAlignment(4);
            return label;
        }
        Exchange exchange = (Exchange)value;
        label.setText(exchange.toString());
        return label;
    }
}

