/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import csbase.client.applications.filetransferclient.FileTransferProxy;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.desktop.DesktopFrame;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferPredefinedConnection;
import csbase.logic.filetransferservice.FileTransferProtocol;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class FastConnectAction
extends FileTransferClientAction {
    private final FileTransferPredefinedConnection predef;

    @Override
    public void actionDone(JComponent component) {
        FileTransferClient application = (FileTransferClient)this.getApplication();
        ApplicationFrame frame = application.getApplicationFrame();
        String passwordStr = this.getString("password.label");
        String title = this.getString("password.title");
        JPasswordField passwordText = new JPasswordField(10);
        JLabel passwordLabel = new JLabel(passwordStr);
        JComponent[][] cmps = new JComponent[][]{{passwordLabel, passwordText}};
        JLabel destLabel = new JLabel();
        destLabel.setText(this.predef.toString());
        destLabel.setFont(new Font("Monospaced", 0, 12));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)destLabel, new GBC(0, 0).horizontal());
        panel.add((Component)GUIUtils.createBasicGridPanel((JComponent[][])cmps), new GBC(0, 1).horizontal());
        int option = JOptionPane.showOptionDialog(frame, panel, title, 2, -1, null, null, null);
        if (option == 2 || option == -1) {
            return;
        }
        String password = passwordText.getText();
        User loggedUser = User.getLoggedUser();
        Object userId = loggedUser.getId();
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        CommonClientProject project = desktopFrame.getProject();
        Object projectId = project.getId();
        FileTransferProtocol protocol = this.predef.getProtocol();
        String serverName = this.predef.getServerName();
        String userName = this.predef.getUserName();
        String homePath = this.predef.getHomePath();
        FileTransferConnection connection = new FileTransferConnection(protocol, serverName, userName, password, userId, projectId, homePath);
        FileTransferProxy proxy = application.getServiceProxy();
        if (!proxy.checkConnection(connection)) {
            String fmt = this.getString("connection.failure.error");
            String err = String.format(fmt, userName, serverName);
            application.showError(err);
            application.setConnection(null);
            return;
        }
        application.setConnection(connection);
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return FileTransferClientUI.FAST_CONNECT_ICON;
    }

    public FastConnectAction(FileTransferClient application, FileTransferPredefinedConnection predef) {
        super(application);
        this.predef = predef;
        this.putValue("Name", predef.getLabel());
        this.putValue("LongDescription", String.valueOf(predef.getUserName()) + "@" + predef.getServerName());
    }
}

