/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.actions;

import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.actions.FlowApplicationAction;
import csbase.client.applications.flowapplication.configurator.FlowAlgorithmConfiguratorView;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphFileDescriptor;
import csbase.client.applications.flowapplication.graph.GraphLayout;
import csbase.client.applications.flowapplication.graph.GraphLink;
import csbase.client.applications.flowapplication.util.FlowApplicationRemoteTask;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;

public abstract class GraphLayoutAction
extends FlowApplicationAction {
    private GraphLayout layout;

    public GraphLayoutAction(FlowApplication application, ImageIcon icon, GraphLayout layout) {
        super(application, icon);
        this.layout = layout;
        this.setEnabled(false);
    }

    @Override
    public void handleActionPerformed(ActionEvent e) {
        Component layoutPreview;
        FlowApplication application = (FlowApplication)this.getApplication();
        ApplicationFrame applicationFrame = application.getApplicationFrame();
        if (this.usePreview() && (layoutPreview = this.createLayoutPreview()) != null) {
            JPanel panel = new JPanel(new BorderLayout());
            String sufix = GraphLayoutAction.class.getSimpleName();
            String message = application.getString(String.valueOf(sufix) + ".preview.message");
            panel.add((Component)new JLabel(message), "North");
            panel.add(layoutPreview, "Center");
            Object[] options = new Object[]{LNG.get((String)"javautils.yes"), LNG.get((String)"javautils.cancel")};
            int result = JOptionPane.showOptionDialog(applicationFrame, panel, application.getName(), 0, -1, null, options, options[0]);
            if (result != 0) {
                return;
            }
        }
        this.doLayout(application.getWorkspace());
    }

    protected void doLayout(Workspace workspace) {
        Graph graph = workspace.getGraph();
        this.layout.doLayout(graph);
        workspace.repaint();
        graph.notifyChangedWorkspace();
    }

    protected abstract boolean usePreview();

    private Component createLayoutPreview() {
        final FlowApplication application = (FlowApplication)this.getApplication();
        final ApplicationFrame applicationFrame = application.getApplicationFrame();
        FlowApplicationRemoteTask<FlowAlgorithmConfiguratorView> task = new FlowApplicationRemoteTask<FlowAlgorithmConfiguratorView>(){

            protected void performTask() throws Exception {
                Workspace workspace = application.getWorkspace();
                Graph graph = workspace.getGraph();
                FlowAlgorithmConfiguratorView configuratorView = new FlowAlgorithmConfiguratorView((Window)applicationFrame, graph, ParameterView.Mode.REPORT, ValidationMode.FULL);
                this.setResult(configuratorView);
            }
        };
        String prefix = GraphLayoutAction.class.getSimpleName();
        String msg = application.getString(String.valueOf(prefix) + ".task.message");
        if (task.execute(applicationFrame, application.getName(), msg)) {
            FlowAlgorithmConfiguratorView configurator = (FlowAlgorithmConfiguratorView)task.getResult();
            Workspace workspace = configurator.getWorkspace();
            this.doLayout(workspace);
            JScrollPane pane = new JScrollPane(workspace);
            double factor = 0.5;
            Dimension screenSize = GUIUtils.getScreenDimension();
            Dimension currentSize = workspace.getPreferredSize();
            double usuableWidth = screenSize.getWidth() * 0.5;
            double newWidth = Math.min(currentSize.getWidth(), usuableWidth);
            double usuableHeight = screenSize.getHeight() * 0.5;
            double newHeight = Math.min(currentSize.getHeight(), usuableHeight);
            Dimension newSize = new Dimension();
            newSize.setSize(newWidth, newHeight);
            pane.setPreferredSize(newSize);
            return pane;
        }
        return null;
    }

    @Override
    public void wasChangedWorkspace(Graph graph) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasElementCreated(Graph graph, GraphElement element) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasElementRemoved(Graph graph, GraphElement element) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasLinkAnchored(Graph graph, GraphLink link, GraphFileDescriptor fileDescriptor) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasLinkUnanchored(Graph graph, GraphLink link, GraphFileDescriptor fileDescriptor) {
        this.updateEnabledStatus(graph);
    }

    private void updateEnabledStatus(Graph graph) {
        this.setEnabled(graph.hasElements());
    }

    protected GraphLayout getLayout() {
        return this.layout;
    }
}

