/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.filters;

import csbase.client.applications.flowapplication.RubberBand;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphFileDescriptor;
import csbase.client.applications.flowapplication.graph.GraphLink;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.messages.PickElementMessage;
import csbase.client.applications.flowapplication.messages.PickGraphMessage;
import csbase.client.applications.flowapplication.messages.PickNodeMessage;
import csbase.client.applications.flowapplication.messages.SelectElementMessage;
import csbase.client.applications.flowapplication.messages.SelectElementsMessage;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import tecgraf.vix.TypeMessage;
import tecgraf.vix.TypeVO;

public final class SelectElementFilter
extends WorkspaceFilter {
    private static final int START = 0;
    private static final int WAITING_DRAG_TO_MOVE_ELEMENT = 1;
    private static final int MOVING_ELEMENT = 2;
    private static final int WAITING_DRAG_TO_RUBBER_BAND = 3;
    private static final int DRAGGING_RUBBER_BAND = 4;
    private static final int WAITING_SELECT_ONE_OF_GROUP = 5;
    private static final int WAITING_DRAG_TO_MOVE_MANY_ELEMENTS = 6;
    private static final int MOVING_MANY_ELEMENTS = 7;
    private static final int WAITING_FINISH_LINK = 8;
    private GraphElement currentElement;
    private GraphLink currentLink;
    private int currentState = 0;
    private Point2D selectedPoint;
    private RubberBand rubberBand;
    private List<GraphElement> elementCollection;

    public SelectElementFilter(Workspace workspace) {
        super(workspace);
    }

    public void callbackButton(Point2D pt, MouseEvent ev) {
        switch (this.currentState) {
            case 1: {
                if (this.wasPressed(ev)) {
                    this.unselectCurrentElement(0);
                }
            }
            case 0: {
                if (!this.wasPressed(ev)) break;
                PickNodeMessage pickNodeMessage = new PickNodeMessage(pt);
                pickNodeMessage.sendVO((TypeVO)this);
                GraphNode node = pickNodeMessage.getNode();
                if (node != null) {
                    this.currentLink = node.createLink(pt);
                    if (this.currentLink != null) {
                        this.repaint();
                        this.currentState = 8;
                        break;
                    }
                }
                PickElementMessage pickElementMessage = new PickElementMessage(pt);
                pickElementMessage.sendVO((TypeVO)this);
                GraphElement element = pickElementMessage.getElement();
                if (element == null) {
                    this.currentElement = null;
                    this.currentState = 3;
                    this.rubberBand = new RubberBand(pt);
                    break;
                }
                this.currentElement = element;
                if (this.currentElement == null) break;
                this.selectedPoint = (Point2D)pt.clone();
                this.currentElement.setSelected(true);
                this.repaint();
                this.currentState = 1;
                break;
            }
            case 2: {
                if (!this.wasReleased(ev)) break;
                this.currentElement.drop(pt);
                this.unselectCurrentElement(0);
                break;
            }
            case 3: {
                this.rubberBand = null;
                this.currentState = 0;
                break;
            }
            case 4: {
                PickGraphMessage message = new PickGraphMessage();
                message.sendVO((TypeVO)this);
                Rectangle2D bounds = this.rubberBand.getBounds();
                this.elementCollection = new LinkedList<GraphElement>(message.getGraph().getElementCollection(bounds));
                for (GraphElement element : this.elementCollection) {
                    element.setSelected(true);
                }
                this.rubberBand = null;
                this.repaint();
                if (this.elementCollection.size() > 0) {
                    this.currentState = 5;
                    break;
                }
                this.reset();
                break;
            }
            case 5: {
                if (!this.wasPressed(ev)) break;
                PickElementMessage pickElementMessage = new PickElementMessage(pt);
                pickElementMessage.sendVO((TypeVO)this);
                GraphElement element = pickElementMessage.getElement();
                if (element != null && this.elementCollection.contains((Object)element)) {
                    this.selectedPoint = (Point2D)pt.clone();
                    this.currentState = 6;
                    break;
                }
                this.unselectElements(0);
                this.currentElement = element;
                if (this.currentElement != null) {
                    this.selectedPoint = (Point2D)pt.clone();
                    this.currentElement.setSelected(true);
                    this.repaint();
                    this.currentState = 1;
                    break;
                }
                this.currentState = 3;
                this.rubberBand = new RubberBand(pt);
                break;
            }
            case 6: {
                this.currentState = 5;
                break;
            }
            case 7: {
                for (GraphElement element : this.elementCollection) {
                    element.drop();
                }
                this.currentState = 5;
                break;
            }
            case 8: {
                GraphFileDescriptor inputFile;
                PickNodeMessage message = new PickNodeMessage(pt);
                message.sendVO((TypeVO)this);
                GraphNode node = message.getNode();
                if (node != null && (inputFile = node.getInputFileDescriptor(pt)) != null) {
                    this.currentLink.increase(pt);
                    if (this.currentLink.finish(inputFile)) {
                        this.currentElement = this.currentLink;
                        this.currentLink = null;
                        this.selectedPoint = (Point2D)pt.clone();
                        this.currentElement.setSelected(true);
                        this.repaint();
                        this.currentState = 1;
                        break;
                    }
                }
                this.currentLink.deattach();
                this.currentLink = null;
                this.reset();
                this.repaint();
                this.currentState = 0;
            }
        }
        super.callbackButton(pt, ev);
    }

    public void callbackDrag(Point2D point, MouseEvent ev) {
        switch (this.currentState) {
            case 1: 
            case 2: {
                this.currentElement.drag(this.selectedPoint, point);
                this.selectedPoint = new Point2D.Double(Math.max(0.0, point.getX()), Math.max(0.0, point.getY()));
                this.repaint();
                this.currentState = 2;
                break;
            }
            case 3: 
            case 4: {
                this.rubberBand.setPoint(point);
                this.repaint();
                this.currentState = 4;
                break;
            }
            case 6: 
            case 7: {
                double startX = this.selectedPoint.getX();
                double endX = point.getX();
                double startY = this.selectedPoint.getY();
                double endY = point.getY();
                double tx = endX - startX;
                double ty = endY - startY;
                for (GraphElement element : this.elementCollection) {
                    element.drag(tx, ty);
                }
                this.selectedPoint = new Point2D.Double(Math.max(0.0, point.getX()), Math.max(0.0, point.getY()));
                this.repaint();
                this.currentState = 7;
                break;
            }
            case 8: {
                this.currentLink.pretentToIncrease(point);
                this.repaint();
            }
        }
    }

    public void callbackRepaint(Graphics2D g) {
        if (this.rubberBand != null) {
            this.rubberBand.paint(g);
        }
        super.callbackRepaint(g);
    }

    public boolean msgHandlerVO(TypeMessage message) {
        if (message instanceof SelectElementMessage) {
            this.handleSelectElementMessage((SelectElementMessage)message);
            return true;
        }
        if (message instanceof SelectElementsMessage) {
            this.handleSelectElementsMessage((SelectElementsMessage)message);
            return true;
        }
        return super.msgHandlerVO(message);
    }

    @Override
    public void wasElementRemoved(Graph graph, GraphElement element) {
        this.reset();
    }

    @Override
    public void wasReseted(Graph graph) {
        this.reset();
    }

    private void handleSelectElementMessage(SelectElementMessage message) {
        this.reset();
        this.currentElement = message.getElement();
        this.currentElement.setSelected(true);
        this.selectedPoint = (Point2D)message.getPoint().clone();
        this.repaint();
        this.currentState = 1;
    }

    private void handleSelectElementsMessage(SelectElementsMessage message) {
        this.reset();
        LinkedList<GraphElement> elements = new LinkedList<GraphElement>(message.getElements());
        if (!elements.isEmpty()) {
            for (GraphElement element : elements) {
                element.setSelected(true);
            }
        }
        this.elementCollection = elements;
        this.repaint();
        this.currentState = 5;
    }

    private void reset() {
        this.currentLink = null;
        this.unselectCurrentElement(0);
        this.unselectElements(0);
        this.unmarkRubberBand();
    }

    private void unmarkRubberBand() {
        this.rubberBand = null;
        this.currentState = 0;
    }

    private void unselectCurrentElement(int nextState) {
        if (this.currentElement != null) {
            this.currentElement.setSelected(false);
            this.currentElement = null;
        }
        this.selectedPoint = null;
        this.repaint();
        this.currentState = nextState;
    }

    private void unselectElements(int nextState) {
        if (this.elementCollection != null) {
            for (GraphElement element : this.elementCollection) {
                element.setSelected(false);
            }
            this.elementCollection = null;
        }
        this.selectedPoint = null;
        this.repaint();
        this.currentState = nextState;
    }

    private boolean wasPressed(MouseEvent ev) {
        return ev.getButton() == 1 && ev.getID() == 501;
    }

    private boolean wasReleased(MouseEvent ev) {
        return ev.getButton() == 1 && ev.getID() == 502;
    }
}

