/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph;

import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.exception.algorithms.ParameterNotFoundException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.lng.LNG;

public final class NodeParameterViewer {
    private DesktopComponentDialog dialog;
    private GraphNode node;

    public NodeParameterViewer(GraphNode node) {
        this.setNode(node);
    }

    public void execute() {
        this.close();
        this.buildGui();
    }

    private void adjustTableAndColumnWidths(JTable table) {
        int tableWidth = this.computeTableWidth(table);
        int tableHeight = table.getPreferredSize().height;
        table.setPreferredScrollableViewportSize(new Dimension(tableWidth, tableHeight));
    }

    private void buildGui() {
        Window window = this.node.getGraph().getParentWindow();
        this.dialog = new DesktopComponentDialog(window);
        this.dialog.setTitle(this.createTitle());
        JButton closeButton = new JButton(this.getString("closeButton"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeParameterViewer.this.close();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(closeButton);
        this.dialog.getRootPane().setDefaultButton(closeButton);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)new JScrollPane(this.createTable()), "Center");
        contentPane.add((Component)buttonPanel, "South");
        this.dialog.setContentPane(contentPane);
        this.dialog.pack();
        this.dialog.center(window);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NodeParameterViewer.this.close();
            }
        });
        this.dialog.setModal(false);
        this.dialog.setVisible(true);
        this.dialog.getRootPane().getDefaultButton().requestFocus();
    }

    private void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    private int computeColumnContentWidth(JTable table, TableColumn column) {
        int columnIndex = column.getModelIndex();
        TableModel model = table.getModel();
        Class<?> columnClass = model.getColumnClass(columnIndex);
        TableCellRenderer renderer = table.getDefaultRenderer(columnClass);
        int maxCellWidth = 0;
        int rowIndex = 0;
        while (rowIndex < table.getRowCount()) {
            Object value = table.getValueAt(rowIndex, columnIndex);
            Component component = renderer.getTableCellRendererComponent(table, value, false, false, rowIndex, columnIndex);
            int cellWidth = component.getPreferredSize().width;
            maxCellWidth = Math.max(maxCellWidth, cellWidth);
            ++rowIndex;
        }
        return maxCellWidth;
    }

    private int computeColumnHeaderWidth(JTable table, TableColumn column) {
        JTableHeader tableHeader = table.getTableHeader();
        Object headerValue = column.getHeaderValue();
        TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        Component component = headerRenderer.getTableCellRendererComponent(null, headerValue, false, false, 0, column.getModelIndex());
        int headerWidth = component.getPreferredSize().width;
        return headerWidth;
    }

    private int computeColumnWidth(JTable table, TableColumn column) {
        int columnHeaderWidth = this.computeColumnHeaderWidth(table, column);
        int columnContentWidth = this.computeColumnContentWidth(table, column);
        int columnWidth = Math.max(columnHeaderWidth, columnContentWidth);
        return columnWidth;
    }

    private int computeTableWidth(JTable table) {
        int tableWidth = 0;
        tableWidth += table.getIntercellSpacing().width;
        int intercellWidth = 0;
        TableColumnModel columnModel = table.getColumnModel();
        int columnIndex = 0;
        while (columnIndex < table.getColumnCount()) {
            TableColumn column = columnModel.getColumn(columnIndex);
            int columnWidth = this.computeColumnWidth(table, column);
            tableWidth += intercellWidth;
            tableWidth += columnWidth;
            column.setPreferredWidth(columnWidth);
            intercellWidth = table.getIntercellSpacing().width;
            ++columnIndex;
        }
        return tableWidth += table.getIntercellSpacing().width;
    }

    private JTable createTable() {
        JTable table = new JTable(this.createTableModel());
        this.adjustTableAndColumnWidths(table);
        return table;
    }

    private TableModel createTableModel() {
        return new AbstractTableModel(){
            private final int COLUMN_COUNT = 3;
            private String[] columnNames;
            private String[][] values;
            {
                this.columnNames = new String[]{NodeParameterViewer.this.getString("labelColumn"), NodeParameterViewer.this.getString("valueColumn"), NodeParameterViewer.this.getString("nameColumn")};
                Set<String> parameterNames = NodeParameterViewer.this.node.getParameterNames();
                this.values = new String[parameterNames.size()][3];
                Iterator<String> parameterNameIterator = parameterNames.iterator();
                try {
                    int i = 0;
                    while (i < this.values.length) {
                        String value;
                        String parameterLabel;
                        String parameterName = parameterNameIterator.next();
                        this.values[i][0] = parameterLabel = NodeParameterViewer.this.node.getParameterLabel(parameterName);
                        String parameterValue = NodeParameterViewer.this.node.getParameterValue(parameterName);
                        this.values[i][1] = value = parameterValue == null ? "" : parameterValue;
                        this.values[i][2] = parameterName;
                        ++i;
                    }
                }
                catch (ParameterNotFoundException e) {
                    IllegalStateException illegalStateException = new IllegalStateException();
                    illegalStateException.initCause(e);
                    throw illegalStateException;
                }
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return this.columnNames[columnIndex];
            }

            @Override
            public int getRowCount() {
                return this.values.length;
            }

            @Override
            public String getValueAt(int rowIndex, int columnIndex) {
                return this.values[rowIndex][columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
    }

    private String createTitle() {
        String title = this.getString("title");
        title = String.format(title, this.node.getAlgorithmName(), this.node.getAlgorithmVersionId());
        return title;
    }

    private String getString(String keySuffix) {
        return LNG.get((String)(String.valueOf(this.getClass().getName()) + "." + keySuffix));
    }

    private void setNode(GraphNode node) {
        if (node == null) {
            throw new IllegalArgumentException("O par\u00e2metro node est\u00e1 nulo.");
        }
        this.node = node;
    }
}

