/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph;

import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphFileDescriptor;
import csbase.client.applications.flowapplication.graph.GraphLayout;
import csbase.client.applications.flowapplication.graph.GraphLink;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.Grid;
import csbase.client.applications.flowapplication.graph.OrthogonalLinkGraphLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;

public class SingleColumnGraphLayout
implements GraphLayout {
    @Override
    public void doLayout(Graph graph) {
        Collection<GraphNode> nodeCollection = graph.getNodeCollection();
        GraphNode topNode = this.findRootNode(nodeCollection);
        if (topNode == null) {
            return;
        }
        Point2D position = this.findRootPosition(graph);
        int i = 0;
        while (i < nodeCollection.size()) {
            topNode.setLocation(position);
            Collection<GraphFileDescriptor> outputs = topNode.getOutputFileDescriptorCollection();
            for (GraphFileDescriptor output : outputs) {
                GraphLink link;
                Collection<GraphLink> links = output.getLinkFromCollection();
                if (links.isEmpty() || (link = links.iterator().next()) == null || !link.isWellFormed()) continue;
                Rectangle2D bounds = topNode.getBounds2D();
                Rectangle2D marginBounds = Grid.includeMargin(bounds);
                double newY = marginBounds.getMaxY() + 24.0;
                position.setLocation(position.getX(), newY);
                topNode = link.getEndNode();
            }
            ++i;
        }
        OrthogonalLinkGraphLayout layout = new OrthogonalLinkGraphLayout();
        layout.doLayout(graph);
    }

    private Point2D findRootPosition(Graph graph) {
        double rootNodeX = Graph.INITIAL_POINT.getX();
        for (GraphNode node : graph.getNodeCollection()) {
            rootNodeX = Math.max(rootNodeX, node.getBounds2D().getCenterX());
        }
        double rootNodeY = Graph.INITIAL_POINT.getY();
        Point2D.Double position = new Point2D.Double(rootNodeX, rootNodeY);
        return position;
    }

    private GraphNode findRootNode(Collection<GraphNode> nodeCollection) {
        GraphNode topNode = null;
        for (GraphNode node : nodeCollection) {
            if (this.hasMultipleOutputLinks(node)) {
                return null;
            }
            boolean hasParent = false;
            Collection<GraphFileDescriptor> inputs = node.getInputFileDescriptorCollection();
            for (GraphFileDescriptor input : inputs) {
                GraphLink link = input.getLinkTo();
                if (link == null || !link.isWellFormed()) continue;
                hasParent = true;
            }
            if (hasParent) continue;
            if (topNode == null) {
                topNode = node;
                continue;
            }
            return null;
        }
        return topNode;
    }

    private boolean hasMultipleOutputLinks(GraphNode node) {
        Collection<GraphFileDescriptor> outputs = node.getOutputFileDescriptorCollection();
        for (GraphFileDescriptor output : outputs) {
            Collection<GraphLink> linkFromCollection = output.getLinkFromCollection();
            if (linkFromCollection.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean isFullyConnected(Graph graph) {
        Collection<GraphLink> linkCollection = graph.getLinkCollection();
        HashSet<GraphNode> connectedNodes = new HashSet<GraphNode>();
        for (GraphLink link : linkCollection) {
            if (!link.isWellFormed()) continue;
            connectedNodes.add(link.getStartNode());
            connectedNodes.add(link.getEndNode());
        }
        Collection<GraphNode> nodes = graph.getNodeCollection();
        return nodes.size() == connectedNodes.size();
    }

    @Override
    public boolean canApplyLayout(Graph graph) {
        return this.isFullyConnected(graph) && this.findRootNode(graph.getNodeCollection()) != null;
    }
}

