/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.multiflow;

import csbase.client.applications.Application;
import csbase.client.applications.flowapplication.multiflow.AbstractMultipleFlowConfigurationDialog;
import csbase.client.util.csvpanel.CSVExceptionNotification;
import csbase.client.util.csvpanel.CSVPanel;
import csbase.client.util.event.EventListener;
import csbase.logic.ClientFile;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import tecgraf.javautils.gui.StatusBar;

public class CSVPreviewDialog
extends AbstractMultipleFlowConfigurationDialog {
    private CSVPanel csvPanel;
    private StatusBar statusBar;
    private String[][] data;
    private int numRowsAsHeader;

    public CSVPreviewDialog(Application application, ClientFile file, int numRowsAsHeader) {
        this(application, file, null, numRowsAsHeader);
    }

    public CSVPreviewDialog(Application application, ClientFile file, String[][] data, int numRowsAsHeader) {
        super(application, file);
        this.data = data;
        this.numRowsAsHeader = numRowsAsHeader;
        this.statusBar = new StatusBar();
        this.csvPanel = new CSVPanel();
    }

    @Override
    protected JComponent createMainComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        this.csvPanel.addExceptionListener(new EventListener<CSVExceptionNotification>(){

            @Override
            public void eventFired(CSVExceptionNotification event) {
                CSVPreviewDialog.this.statusBar.setError(event.getMessage());
            }
        });
        panel.add((Component)this.csvPanel, "Center");
        panel.add((Component)this.statusBar, "South");
        this.statusBar.showStatusBar();
        if (this.data != null) {
            this.csvPanel.setData(this.data, false);
        } else {
            this.csvPanel.openFile(this.configurationFile, false);
        }
        this.csvPanel.setNumRowsAsHeader(this.numRowsAsHeader);
        return panel;
    }

    @Override
    protected boolean validateFields() {
        if (!this.statusBar.getText().trim().isEmpty()) {
            ((Application)this.getApplication()).showError(this.statusBar.getText());
            return false;
        }
        return super.validateFields();
    }
}

