/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.multiflow;

import csbase.client.applications.Application;
import csbase.client.applications.flowapplication.multiflow.AbstractMultipleFlowConfigurationDialog;
import csbase.client.applications.flowapplication.multiflow.tree.AlgorithmNode;
import csbase.client.applications.flowapplication.multiflow.tree.ParameterNode;
import csbase.client.applications.flowapplication.multiflow.tree.ParameterSelection;
import csbase.client.applications.flowapplication.multiflow.tree.ParameterSelectionModel;
import csbase.client.applications.flowapplication.multiflow.tree.ParameterSelectionNode;
import csbase.client.applications.flowapplication.multiflow.tree.ParameterSelectionTree;
import csbase.client.applications.flowapplication.multiflow.tree.RootNode;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowLink;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.LinkParameter;
import csbase.logic.algorithms.flows.NodeParameter;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tecgraf.javautils.gui.GBC;

public class ParameterSelectionDialog
extends AbstractMultipleFlowConfigurationDialog {
    private ParameterSelectionTree parameterSelectionTree;
    private JCheckBox selectEmptyParametersCheckBox;

    public ParameterSelectionDialog(Application application, Flow flow) {
        super(application);
        this.parameterSelectionTree = this.createTree(flow);
    }

    @Override
    protected JComponent createMainComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        GBC gbc = new GBC().insets(5);
        JScrollPane treePane = new JScrollPane(this.parameterSelectionTree);
        panel.add((Component)treePane, new GBC(gbc).both());
        this.selectEmptyParametersCheckBox = new JCheckBox(this.getString("ParameterSelectionDialog.selectEmptyParamsLabel"));
        this.selectEmptyParametersCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = ParameterSelectionDialog.this.selectEmptyParametersCheckBox.isSelected();
                ParameterSelectionDialog.this.changeEmptyParametersSelection(selected);
            }
        });
        panel.add((Component)this.selectEmptyParametersCheckBox, new GBC(gbc).gridy(1).west());
        return panel;
    }

    private ParameterSelectionTree createTree(Flow flow) {
        RootNode root = new RootNode(flow);
        Set nodes = flow.getNodes();
        for (FlowNode flowNode : nodes) {
            Set parameters = flowNode.getParameters();
            AlgorithmNode treeNode = new AlgorithmNode(flowNode);
            root.add(treeNode);
            for (NodeParameter parameter : parameters) {
                if (this.isLinked(flow, parameter, flowNode.getId())) continue;
                ParameterNode parameterNode = new ParameterNode(parameter, flowNode);
                treeNode.add(parameterNode);
            }
        }
        ParameterSelectionTree tree = new ParameterSelectionTree(root);
        return tree;
    }

    private boolean isLinked(Flow flow, NodeParameter parameter, int nodeId) {
        Set links = flow.getLinks();
        for (FlowLink link : links) {
            LinkParameter input = link.getInput();
            LinkParameter output = link.getOutput();
            String name = parameter.getName();
            if ((!name.equals(input.getName()) || nodeId != input.getNodeId()) && (!name.equals(output.getName()) || nodeId != output.getNodeId())) continue;
            return true;
        }
        return false;
    }

    public List<ParameterSelection> getParameterSelection() {
        ParameterSelectionModel parameterSelectionModel = this.parameterSelectionTree.getParameterSelectionModel();
        TreePath[] paths = parameterSelectionModel.getSelectionPaths();
        ArrayList<ParameterSelection> selectedParams = new ArrayList<ParameterSelection>();
        if (paths != null) {
            TreePath[] treePathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                Object node = path.getLastPathComponent();
                if (node instanceof ParameterSelectionNode) {
                    ParameterSelectionNode selection = (ParameterSelectionNode)node;
                    selectedParams.addAll(selection.getParameterSelection());
                }
                ++n2;
            }
        }
        return selectedParams;
    }

    @Override
    protected boolean validateFields() {
        ParameterSelectionModel parameterSelectionModel = this.parameterSelectionTree.getParameterSelectionModel();
        TreePath[] paths = parameterSelectionModel.getSelectionPaths();
        if (paths != null) {
            return true;
        }
        Object application = this.getApplication();
        ((Application)application).showError(this, this.getString("ParameterSelectionDialog.emptySelectionMessage"));
        return false;
    }

    private void changeEmptyParametersSelection(boolean select) {
        ParameterSelectionModel parameterSelectionModel = this.parameterSelectionTree.getParameterSelectionModel();
        TreeModel model = this.parameterSelectionTree.getModel();
        RootNode root = (RootNode)model.getRoot();
        Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TreeNode element = enumeration.nextElement();
            if (!(element instanceof ParameterNode)) continue;
            ParameterNode node = (ParameterNode)element;
            ParameterSelection selection = node.getUserObject();
            NodeParameter parameter = selection.parameter;
            if (parameter.getValue() != null) continue;
            TreePath path = new TreePath(node.getPath());
            if (select) {
                parameterSelectionModel.addSelectionPath(path);
            } else {
                parameterSelectionModel.removeSelectionPath(path);
            }
            this.parameterSelectionTree.expandPath(path.getParentPath());
        }
    }
}

