/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.multiflow.tree;

import java.util.ArrayList;
import java.util.Stack;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ParameterSelectionModel
extends DefaultTreeSelectionModel {
    private TreeModel model;

    public ParameterSelectionModel(TreeModel model) {
        this.model = model;
        this.setSelectionMode(4);
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        TreePath path;
        int i = 0;
        while (i < paths.length) {
            path = paths[i];
            TreePath[] selectionPaths = this.getSelectionPaths();
            if (selectionPaths == null) break;
            ArrayList<TreePath> toBeRemoved = new ArrayList<TreePath>();
            int j = 0;
            while (j < selectionPaths.length) {
                TreePath selectedPath = selectionPaths[j];
                if (path.isDescendant(selectedPath)) {
                    toBeRemoved.add(selectedPath);
                }
                ++j;
            }
            super.removeSelectionPaths(toBeRemoved.toArray(new TreePath[toBeRemoved.size()]));
            ++i;
        }
        i = 0;
        while (i < paths.length) {
            path = paths[i];
            TreePath temp = null;
            while (this.areSiblingsSelected(path)) {
                temp = path;
                if (path.getParentPath() == null) break;
                path = path.getParentPath();
            }
            if (temp != null) {
                if (temp.getParentPath() != null) {
                    this.addSelectionPath(temp.getParentPath());
                } else {
                    TreePath[] selectionPaths = this.getSelectionPaths();
                    if (selectionPaths != null) {
                        this.removeSelectionPaths(selectionPaths);
                    }
                    super.addSelectionPaths(new TreePath[]{temp});
                }
            } else {
                super.addSelectionPaths(new TreePath[]{path});
            }
            ++i;
        }
    }

    public boolean isPathSelected(TreePath path, boolean dig) {
        if (!dig) {
            return super.isPathSelected(path);
        }
        TreePath selectedPath = path;
        while (selectedPath != null && !super.isPathSelected(selectedPath)) {
            selectedPath = selectedPath.getParentPath();
        }
        return selectedPath != null;
    }

    private boolean areSiblingsSelected(TreePath path) {
        TreePath parent = path.getParentPath();
        if (parent == null) {
            return true;
        }
        Object node = path.getLastPathComponent();
        Object parentNode = parent.getLastPathComponent();
        int childCount = this.model.getChildCount(parentNode);
        int i = 0;
        while (i < childCount) {
            Object childNode = this.model.getChild(parentNode, i);
            if (childNode != node && !this.isPathSelected(parent.pathByAddingChild(childNode))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        int i = 0;
        while (i < paths.length) {
            TreePath path = paths[i];
            if (path.getPathCount() == 1) {
                super.removeSelectionPaths(new TreePath[]{path});
            } else {
                this.toggleRemoveSelection(path);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void toggleRemoveSelection(TreePath path) {
        Stack<TreePath> stack = new Stack<TreePath>();
        TreePath parent = path.getParentPath();
        while (parent != null && !this.isPathSelected(parent)) {
            stack.push(parent);
            parent = parent.getParentPath();
        }
        if (parent == null) {
            super.removeSelectionPaths(new TreePath[]{path});
            return;
        }
        stack.push(parent);
        while (!stack.isEmpty()) {
            TreePath temp = (TreePath)stack.pop();
            TreePath peekPath = stack.isEmpty() ? path : (TreePath)stack.peek();
            Object node = temp.getLastPathComponent();
            Object peekNode = peekPath.getLastPathComponent();
            int childCount = this.model.getChildCount(node);
            int i = 0;
            while (i < childCount) {
                Object childNode = this.model.getChild(node, i);
                if (childNode != peekNode) {
                    super.addSelectionPaths(new TreePath[]{temp.pathByAddingChild(childNode)});
                }
                ++i;
            }
        }
        super.removeSelectionPaths(new TreePath[]{parent});
    }
}

