/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.imageviewer;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationAboutAction;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.imageviewer.ImageViewerIO;
import csbase.client.applications.imageviewer.actions.effects.ImageViewerBlurAction;
import csbase.client.applications.imageviewer.actions.effects.ImageViewerGrayAction;
import csbase.client.applications.imageviewer.actions.effects.ImageViewerLightAction;
import csbase.client.applications.imageviewer.actions.effects.ImageViewerRGBAction;
import csbase.client.applications.imageviewer.actions.io.ImageViewerCloseAction;
import csbase.client.applications.imageviewer.actions.io.ImageViewerOpenAction;
import csbase.client.applications.imageviewer.actions.io.ImageViewerRestoreAction;
import csbase.client.applications.imageviewer.actions.io.ImageViewerSaveAction;
import csbase.client.applications.imageviewer.actions.io.ImageViewerSaveAsAction;
import csbase.client.applications.imageviewer.actions.view.ImageViewerZoomFitAction;
import csbase.client.applications.imageviewer.actions.view.ImageViewerZoomInAction;
import csbase.client.applications.imageviewer.actions.view.ImageViewerZoomOutAction;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import tecgraf.javautils.gui.StandardDialogs;

public class ImageViewer
extends Application {
    public static final double ZOOM_STEP_FACTOR = 1.05;
    private final ImgPanel imagePanel = new ImgPanel();
    private boolean needSave = false;
    private Image currentImage;
    private Image originalImage;
    private double zoom = 1.0;
    private int width = 0;
    private int height = 0;
    private boolean ready = false;
    private ImgObserver observer = null;
    private ClientFile currentFile;

    public final double getZoom() {
        return this.zoom;
    }

    public final void setZoom(double zoom) {
        if (zoom < 0.05 || zoom > 10.0) {
            return;
        }
        this.zoom = zoom;
        this.updateImagePanelSize();
        this.imagePanel.repaint();
    }

    private void updateImagePanelSize() {
        if (this.ready) {
            int t2X = (int)Math.round((double)this.width * this.zoom);
            int t2Y = (int)Math.round((double)this.height * this.zoom);
            Dimension dimension = new Dimension(t2X, t2Y);
            this.imagePanel.setSize(dimension);
            this.imagePanel.setMinimumSize(dimension);
            this.imagePanel.setPreferredSize(dimension);
        }
    }

    public final Image getCurrentImage() {
        return this.currentImage;
    }

    public final void setSaveNeeded(boolean flag) {
        this.needSave = flag;
        this.updateTitle();
    }

    public BufferedImage getCurrentBufferedImage() {
        BufferedImage bi;
        if (this.currentImage == null) {
            return null;
        }
        if (this.currentImage instanceof BufferedImage && (bi = (BufferedImage)this.currentImage).getType() == 1) {
            return bi;
        }
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        int w = this.currentImage.getWidth(null);
        int h = this.currentImage.getHeight(null);
        try {
            int transparency = 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(w, h, transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            bimage = new BufferedImage(w, h, type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(this.currentImage, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public final void setCurrentImage(Image image) {
        this.currentImage = image;
        this.updateImagePanel();
    }

    public final ClientFile getCurrentFile() {
        return this.currentFile;
    }

    private void createMainFrame() {
        ApplicationFrame mainFrame = this.getApplicationFrame();
        mainFrame.setJMenuBar(this.createMenuBar());
        mainFrame.setSize(new Dimension(800, 600));
        Container cp = mainFrame.getContentPane();
        cp.add((Component)this.createToolBar(), "North");
        cp.add((Component)this.createViewer(), "Center");
    }

    private void updateTitle() {
        String filename = this.currentFile == null ? null : this.currentFile.getName();
        ApplicationFrame frame = this.getApplicationFrame();
        String title = this.getName();
        if (filename != null) {
            title = String.valueOf(title) + " - " + filename;
        }
        if (this.needSave) {
            title = String.valueOf(title) + "*";
        }
        frame.setTitle(title);
    }

    public boolean openFile(ClientProjectFile newFile) {
        Image newImage;
        if (newFile == null) {
            return false;
        }
        try {
            newImage = ImageViewerIO.readTask(this, (ClientFile)newFile);
            if (newImage == null) {
                return false;
            }
        }
        catch (Exception e) {
            this.showError(e.getMessage());
            return false;
        }
        this.currentImage = this.originalImage = newImage;
        this.updateImagePanel();
        return true;
    }

    private void updateImagePanel() {
        if (this.currentImage == null) {
            return;
        }
        this.observer = new ImgObserver();
        this.width = this.currentImage.getWidth(this.observer);
        this.height = this.currentImage.getHeight(this.observer);
        Toolkit.getDefaultToolkit().prepareImage(this.currentImage, this.width, this.height, this.observer);
        this.ready = this.width >= 0 && this.height >= 0;
        this.updateImagePanelSize();
        this.imagePanel.repaint();
    }

    public void closeFile() {
        this.originalImage = null;
        this.currentImage = null;
        this.observer = null;
        this.width = -1;
        this.height = -1;
        this.ready = false;
        this.imagePanel.repaint();
        this.setCurrentFile(null);
    }

    private JComponent createViewer() {
        JScrollPane scrollPane = new JScrollPane(this.imagePanel);
        int hNeeded = 30;
        int vNeeded = 20;
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        return scrollPane;
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar(this.getName());
        toolBar.setFloatable(false);
        toolBar.add(new ImageViewerOpenAction(this));
        toolBar.add(new ImageViewerSaveAction(this));
        toolBar.add(new ImageViewerSaveAsAction(this));
        toolBar.addSeparator();
        toolBar.add(new ImageViewerZoomInAction(this));
        toolBar.add(new ImageViewerZoomOutAction(this));
        toolBar.add(new ImageViewerZoomFitAction(this));
        toolBar.addSeparator();
        toolBar.add(new ImageViewerRestoreAction(this));
        return toolBar;
    }

    private JMenu createHelpMenu() {
        JMenu menu = new JMenu(this.getString("menu.help"));
        menu.add(new ApplicationAboutAction(this));
        return menu;
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu(this.getString("menu.file"));
        menu.add(new ImageViewerOpenAction(this));
        menu.add(new ImageViewerSaveAction(this));
        menu.add(new ImageViewerSaveAsAction(this));
        menu.add(new ImageViewerCloseAction(this));
        menu.addSeparator();
        menu.add(new ApplicationExitAction(this));
        return menu;
    }

    private JMenu createViewMenu() {
        JMenu menu = new JMenu(this.getString("menu.view"));
        menu.add(new ImageViewerZoomInAction(this));
        menu.add(new ImageViewerZoomOutAction(this));
        menu.add(new ImageViewerZoomFitAction(this));
        return menu;
    }

    private JMenu createEffectsMenu() {
        JMenu menu = new JMenu(this.getString("menu.effects"));
        menu.add(new ImageViewerGrayAction(this));
        menu.add(new ImageViewerLightAction(this));
        menu.add(new ImageViewerRGBAction(this));
        menu.add(new ImageViewerBlurAction(this));
        menu.addSeparator();
        menu.add(new ImageViewerRestoreAction(this));
        return menu;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createViewMenu());
        menuBar.add(this.createEffectsMenu());
        menuBar.add(this.createHelpMenu());
        return menuBar;
    }

    @Override
    public void killApplication() {
    }

    @Override
    public boolean userCanKillApplication() {
        if (this.needSave) {
            String title;
            String msg = this.getString("msg.close.without.save");
            ApplicationFrame frame = this.getApplicationFrame();
            int answer = StandardDialogs.showYesNoDialog((Component)frame, (String)(title = this.getName()), (Object)msg);
            return answer == 0;
        }
        return true;
    }

    @Override
    public void sendMessage(String name, Object value, String senderId) {
        ClientProjectFile file;
        boolean opened;
        if (value == null) {
            return;
        }
        if (name.equals("PROJECT_FILE") && (opened = this.openFile(file = (ClientProjectFile)value))) {
            this.setCurrentFile((ClientFile)file);
        }
    }

    public ImageViewer(String id) {
        super(id);
        this.createMainFrame();
    }

    public void restoreOriginalImage() {
        if (this.originalImage == null) {
            return;
        }
        this.setCurrentImage(this.originalImage);
    }

    public void setCurrentFile(ClientFile file) {
        this.currentFile = file == null ? null : file;
        this.updateTitle();
    }

    class ImgObserver
    implements ImageObserver {
        ImgObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean imageUpdate(Image i, int f, int x, int y, int w, int h) {
            ImageViewer imageViewer = ImageViewer.this;
            synchronized (imageViewer) {
                block8: {
                    block7: {
                        if ((f & 0x40) != 64 && (f & 0x80) != 128) break block7;
                        ImageViewer.this.currentImage = null;
                        return false;
                    }
                    if ((f & 1) == 1) {
                        ImageViewer.this.width = w;
                    }
                    if ((f & 2) == 2) {
                        ImageViewer.this.height = h;
                    }
                    if ((f & 0x20) != 32) break block8;
                    ImageViewer.this.ready = true;
                    ImageViewer.this.imagePanel.revalidate();
                    ImageViewer.this.imagePanel.repaint();
                    return false;
                }
                return true;
            }
        }
    }

    class ImgPanel
    extends JPanel {
        @Override
        public void paintComponent(Graphics g) {
            if (ImageViewer.this.currentImage == null) {
                super.paintComponent(g);
                return;
            }
            super.paintComponent(g);
            if (!ImageViewer.this.ready) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            int sizeX = Math.round(ImageViewer.this.imagePanel.getWidth());
            int sizeY = Math.round(ImageViewer.this.imagePanel.getHeight());
            int t2X = (int)Math.round((double)ImageViewer.this.width * ImageViewer.this.zoom);
            int t2Y = (int)Math.round((double)ImageViewer.this.height * ImageViewer.this.zoom);
            int t3X = (int)Math.round((double)(sizeX - t2X) / 2.0);
            int t3Y = (int)Math.round((double)(sizeY - t2Y) / 2.0);
            if (t3X < 0) {
                t3X = 0;
            }
            if (t3Y < 0) {
                t3Y = 0;
            }
            AffineTransform transf = new AffineTransform();
            transf.setToIdentity();
            transf.scale(ImageViewer.this.zoom, ImageViewer.this.zoom);
            transf.translate(t3X, t3Y);
            g2d.drawImage(ImageViewer.this.currentImage, transf, ImageViewer.this.observer);
        }
    }
}

