/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.imageviewer;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationTask;
import csbase.client.applications.imageviewer.ImageViewer;
import csbase.logic.ClientFile;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageViewerIO {
    private static String getString(ImageViewer application, String tag) {
        String prefix = ImageViewerIO.class.getSimpleName();
        return application.getString(String.valueOf(prefix) + "." + tag);
    }

    public static void writeTask(ImageViewer application, final BufferedImage image, ClientFile file) throws Exception {
        final OutputStream stream = file.getOutputStream();
        final String type = file.getType();
        String msg = ImageViewerIO.getString(application, "write.task.msg");
        ApplicationTask<Void> task = new ApplicationTask<Void>((Application)application, msg){

            @Override
            protected void performTask() throws Exception {
                ImageIO.write((RenderedImage)image, type, stream);
                stream.close();
            }
        };
        boolean executed = task.execute();
        if (!executed) {
            Exception error = task.getError();
            if (error != null) {
                throw error;
            }
            String tag = "write.error.msg";
            String err = ImageViewerIO.getString(application, "write.error.msg");
            throw new Exception(err);
        }
    }

    public static Image readTask(ImageViewer app, ClientFile file) throws Exception {
        if (file == null) {
            String tag = "read.null.file.error.msg";
            String err = ImageViewerIO.getString(app, "read.null.file.error.msg");
            throw new Exception(err);
        }
        if (file.isDirectory()) {
            String tag = "read.directory.file.error.msg";
            String err = ImageViewerIO.getString(app, "read.directory.file.error.msg");
            throw new Exception(err);
        }
        final InputStream stream = file.getInputStream();
        String msg = ImageViewerIO.getString(app, "read.task.msg");
        ApplicationTask<BufferedImage> task = new ApplicationTask<BufferedImage>((Application)app, msg){

            @Override
            public void performTask() throws Exception {
                BufferedImage read = ImageIO.read(stream);
                this.setResult(read);
                stream.close();
            }
        };
        boolean executed = task.execute();
        if (!executed) {
            String err = ImageViewerIO.getString(app, "read.error.msg");
            Exception error = task.getError();
            if (error != null) {
                err = String.valueOf(err) + "\n" + error.getMessage();
            }
            throw new Exception(err);
        }
        Image img = (Image)task.getResult();
        if (img == null) {
            String err = ImageViewerIO.getString(app, "read.error.msg");
            throw new Exception(err);
        }
        return img;
    }
}

