/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.imageviewer.effects;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.ApplicationTask;
import csbase.client.applications.imageviewer.ImageViewer;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public abstract class AbstractEffect {
    private final ImageViewer application;
    private JLabel previewLabel = null;

    protected final String getClassString(String tag) {
        String className = this.getClass().getSimpleName();
        String text = this.application.getString(String.valueOf(className) + "." + tag);
        return text;
    }

    protected final String getString(String tag) {
        String text = this.application.getString(tag);
        return text;
    }

    public final void setPreviewLabel(JLabel previewLabel) {
        this.previewLabel = previewLabel;
    }

    public final void applyImageTransformation() throws Exception {
        ApplicationFrame frame = this.application.getApplicationFrame();
        JRootPane component = frame.getRootPane();
        BufferedImage result = this.createNewImage(component);
        if (result == null) {
            return;
        }
        this.application.setCurrentImage(result);
    }

    public final boolean updatePreview() {
        block4: {
            if (this.previewLabel == null) {
                return false;
            }
            try {
                BufferedImage result = this.createNewImage(this.previewLabel);
                if (result == null) break block4;
                this.previewLabel.setIcon(new ImageIcon(result));
                return true;
            }
            catch (Exception e) {
                this.previewLabel.setIcon(ApplicationImages.ICON_ERROR_32);
                this.previewLabel.setText(e.getMessage());
                return false;
            }
        }
        this.previewLabel.setIcon(ApplicationImages.ICON_QUESTION_32);
        return false;
    }

    private BufferedImage createNewImage(JComponent cmp) throws Exception {
        final BufferedImage image = this.application.getCurrentBufferedImage();
        if (image == null) {
            return null;
        }
        String msg = this.application.getString("effect.task.msg");
        ApplicationTask<BufferedImage> task = new ApplicationTask<BufferedImage>((Application)this.application, msg){

            @Override
            protected void handleError(Exception exception) {
            }

            @Override
            protected void performTask() {
                BufferedImage newImage = AbstractEffect.this.transformImage(image);
                this.setResult(newImage);
            }
        };
        boolean executed = task.execute();
        if (!executed) {
            Exception error = task.getError();
            if (error != null) {
                throw error;
            }
            String err = this.application.getString("effect.error.msg");
            throw new Exception(err);
        }
        BufferedImage result = (BufferedImage)task.getResult();
        return result;
    }

    protected AbstractEffect(ImageViewer application) {
        this.application = application;
    }

    public abstract JPanel getParameterPanel();

    protected abstract BufferedImage transformImage(BufferedImage var1);

    public abstract void resetParameters();

    protected ImageViewer getApplication() {
        return this.application;
    }
}

