/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.imageviewer.effects;

import csbase.client.applications.imageviewer.ImageViewer;
import csbase.client.applications.imageviewer.effects.AbstractEffect;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tecgraf.javautils.gui.GUIUtils;

public class BlurEffect
extends AbstractEffect {
    final JSlider intensitySlider = new JSlider(0);

    public BlurEffect(ImageViewer application) {
        super(application);
        this.intensitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (BlurEffect.this.intensitySlider.isEnabled()) {
                    BlurEffect.this.updatePreview();
                }
            }
        });
    }

    @Override
    public JPanel getParameterPanel() {
        JLabel intensityLabel = new JLabel(this.getString("BlurEffect.intensity.label"));
        JComponent[][] row = new JComponent[][]{{intensityLabel, this.intensitySlider}};
        return GUIUtils.createBasicGridPanel((JComponent[][])row);
    }

    @Override
    protected BufferedImage transformImage(BufferedImage image) {
        return new GaussOperator(this.intensitySlider.getValue()).filter(image, null);
    }

    @Override
    public void resetParameters() {
        this.intensitySlider.setValue(0);
    }

    abstract class AbstractMatrixFilter {
        AbstractMatrixFilter() {
        }

        private void squarenessCheck(double[][] shouldBeSquaredMatrix) {
            int matrixTotalColumns = shouldBeSquaredMatrix.length;
            int i = 0;
            while (i < matrixTotalColumns) {
                int matrixTotalRows = shouldBeSquaredMatrix[i].length;
                if (matrixTotalColumns != matrixTotalRows) {
                    throw new IllegalArgumentException("Vetor 2D passado n\u00e3o \u00e9 quadrada");
                }
                ++i;
            }
        }

        protected Matrix matrixFrom(Raster raster, int componentIndex, int x, int y, int totalRowCol) {
            Matrix resultMatrix = new Matrix(totalRowCol);
            int edgeOffset = (totalRowCol - 1) / 2;
            int xOffset = -edgeOffset;
            int mx = 0;
            while (mx < totalRowCol) {
                int yOffset = -edgeOffset;
                int my = 0;
                while (my < totalRowCol) {
                    resultMatrix.setValue(mx, my, raster.getSampleDouble(xOffset + x, yOffset + y, componentIndex));
                    ++yOffset;
                    ++my;
                }
                ++xOffset;
                ++mx;
            }
            return resultMatrix;
        }

        private void borderPixelCheck(Raster raster, int x, int y, Matrix matrix) {
            int edgeOffset = (matrix.getRowNum() - 1) / 2;
            if (x - edgeOffset < 0 || y - edgeOffset < 0 || x + edgeOffset >= raster.getWidth() || y + edgeOffset >= raster.getHeight()) {
                throw new IllegalArgumentException("Pixel passado na borda do raster e este m\u00e9todo n\u00e3o suporta valores de pixel na borda");
            }
        }

        class Matrix {
            private final double[][] matrix2dArray;

            Matrix(int oddRowsCols) {
                if (oddRowsCols % 2 == 0) {
                    this.throwNotOddNumberIllegalArgumentException();
                }
                this.matrix2dArray = this.newSquared2dArray(oddRowsCols);
            }

            Matrix(double[][] matrix2d) {
                AbstractMatrixFilter.this.squarenessCheck(matrix2d);
                if (!this.oddRowCheck(matrix2d) || !this.oddColumnCheck(matrix2d)) {
                    this.throwNotOddNumberIllegalArgumentException();
                }
                this.matrix2dArray = matrix2d;
            }

            private double[][] newSquared2dArray(int n) {
                double[][] resultMatrix = new double[n][];
                int i = 0;
                while (i < n) {
                    resultMatrix[i] = new double[n];
                    ++i;
                }
                return resultMatrix;
            }

            int getRowNum() {
                return this.matrix2dArray.length;
            }

            double sumValues() {
                double totalSum = 0.0;
                int x = 0;
                while (x < this.getRowNum()) {
                    int y = 0;
                    while (y < this.getRowNum()) {
                        totalSum += this.getValue(x, y);
                        ++y;
                    }
                    ++x;
                }
                return totalSum;
            }

            private boolean oddColumnCheck(double[][] matrix2dArray) {
                return matrix2dArray.length % 2 == 1;
            }

            private boolean oddRowCheck(double[][] matrix2dArray) {
                int i = 0;
                while (i < matrix2dArray.length) {
                    if (matrix2dArray[i].length % 2 == 0) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            private void throwNotOddNumberIllegalArgumentException() {
                throw new IllegalArgumentException("A matriz deve ser quadrada e ter um n\u00famero \u00edmpar de linhas e colunas");
            }

            private void setValue(int x, int y, double value) {
                this.matrix2dArray[x][y] = value;
            }

            double getValue(int x, int y) {
                return this.matrix2dArray[x][y];
            }

            Matrix multiply(Matrix otherMatrix) {
                if (this.getRowNum() != otherMatrix.getRowNum()) {
                    throw new IllegalArgumentException("Matrizes precisam ser do mesmo temanho para a multiplica\u00e7\u00e3o componente a componente");
                }
                Matrix resultMatrix = new Matrix(this.getRowNum());
                int x = 0;
                while (x < this.getRowNum()) {
                    int y = 0;
                    while (y < this.getRowNum()) {
                        double result = this.getValue(x, y) * otherMatrix.getValue(x, y);
                        resultMatrix.setValue(x, y, result);
                        ++y;
                    }
                    ++x;
                }
                return resultMatrix;
            }
        }
    }

    class GaussOperator
    extends AbstractMatrixFilter
    implements BufferedImageOp {
        private final double intensityFactor;

        GaussOperator(int intensity) {
            if (intensity < 0 || intensity > 100) {
                throw new IllegalArgumentException("Intensidade deve ser de 0 a 100");
            }
            this.intensityFactor = (double)intensity / 100.0;
        }

        private BufferedImage applyGaussOp(BufferedImage src, BufferedImage dest) {
            Raster raster = src.getData();
            int width = raster.getWidth();
            int height = raster.getHeight();
            if (dest == null) {
                dest = new BufferedImage(width, height, src.getType());
            }
            WritableRaster writableRaster = dest.getRaster();
            double max = 0.0;
            int numComponents = src.getColorModel().getNumColorComponents();
            AbstractMatrixFilter.Matrix gaussMatrix = this.gaussMatrixFromIntensity(this.intensityFactor);
            int x = 1;
            while (x < width - 1) {
                int y = 1;
                while (y < height - 1) {
                    double[] components = new double[numComponents];
                    int c = 0;
                    while (c < components.length) {
                        AbstractMatrixFilter.Matrix rasterMatrix = this.matrixFrom(raster, c, x, y, gaussMatrix.getRowNum());
                        AbstractMatrixFilter.Matrix multResult = rasterMatrix.multiply(gaussMatrix);
                        components[c] = multResult.sumValues();
                        ++c;
                    }
                    writableRaster.setPixel(x, y, components);
                    ++y;
                }
                ++x;
            }
            return dest;
        }

        private AbstractMatrixFilter.Matrix gaussMatrixFromIntensity(double intensityFactor) {
            int y;
            double[][] matrixRet = new double[3][];
            int x = 0;
            while (x < matrixRet.length) {
                matrixRet[x] = new double[matrixRet.length];
                int y2 = 0;
                while (y2 < matrixRet.length) {
                    matrixRet[x][y2] = 1.0;
                    ++y2;
                }
                ++x;
            }
            double[] dArray = matrixRet[1];
            dArray[1] = dArray[1] * (1.0 - intensityFactor);
            double[] dArray2 = matrixRet[0];
            dArray2[1] = dArray2[1] * intensityFactor;
            double[] dArray3 = matrixRet[1];
            dArray3[0] = dArray3[0] * intensityFactor;
            double[] dArray4 = matrixRet[1];
            dArray4[2] = dArray4[2] * intensityFactor;
            double[] dArray5 = matrixRet[2];
            dArray5[1] = dArray5[1] * intensityFactor;
            double[] dArray6 = matrixRet[0];
            dArray6[0] = dArray6[0] * (intensityFactor * intensityFactor);
            double[] dArray7 = matrixRet[0];
            dArray7[2] = dArray7[2] * (intensityFactor * intensityFactor);
            double[] dArray8 = matrixRet[2];
            dArray8[0] = dArray8[0] * (intensityFactor * intensityFactor);
            double[] dArray9 = matrixRet[2];
            dArray9[2] = dArray9[2] * (intensityFactor * intensityFactor);
            double sum = 0.0;
            int x2 = 0;
            while (x2 < matrixRet.length) {
                y = 0;
                while (y < matrixRet.length) {
                    sum += matrixRet[x2][y];
                    ++y;
                }
                ++x2;
            }
            x2 = 0;
            while (x2 < matrixRet.length) {
                y = 0;
                while (y < matrixRet.length) {
                    double[] dArray10 = matrixRet[x2];
                    int n = y++;
                    dArray10[n] = dArray10[n] / sum;
                }
                ++x2;
            }
            return (AbstractMatrixFilter)this.new AbstractMatrixFilter.Matrix(matrixRet);
        }

        @Override
        public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
            return null;
        }

        @Override
        public BufferedImage filter(BufferedImage src, BufferedImage dest) {
            return this.applyGaussOp(src, dest);
        }

        @Override
        public Rectangle2D getBounds2D(BufferedImage src) {
            return null;
        }

        @Override
        public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
            return null;
        }

        @Override
        public RenderingHints getRenderingHints() {
            return null;
        }
    }
}

