/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.actions.AppendUsersTask;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;
import csbase.client.applications.projectsmanager.usersearch.UserDialog;
import csbase.logic.User;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;

public class AppendUsersAction
extends ProjectsManagerAction {
    private final boolean readOnly;

    public AppendUsersAction(ProjectsManager projectsManager, boolean readOnly) {
        super(projectsManager);
        this.readOnly = readOnly;
        if (readOnly) {
            this.putValue("Name", this.getString("AppendUsersAction.readonly.name"));
        } else {
            this.putValue("Name", this.getString("AppendUsersAction.readwrite.name"));
        }
    }

    @Override
    public void actionDone() throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projectList = projectsManager.getSelectedProjects();
        if (projectList == null || projectList.size() == 0) {
            return;
        }
        List<ProjectsManagerData> projects = this.validateProjects(projectList);
        if (projects == null) {
            return;
        }
        String title = this.getString("AppendUsersAction.selection.title");
        Set<Object> ids = UserDialog.showUserSelectionDialog(projectsManager.getApplicationFrame(), projectsManager.getUsers(), true, title);
        if (ids == null) {
            return;
        }
        this.runTask(projects, ids);
        projectsManager.refreshProjectsTable();
        projectsManager.refreshInfoPanel();
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ProjectsManagerUI.ADD_SHARED;
    }

    @Override
    protected List<ProjectsManagerData> validateProjects(List<ProjectsManagerData> projectList) {
        String someDeniedMessage;
        int res;
        ArrayList<ProjectsManagerData> prjList = new ArrayList<ProjectsManagerData>();
        prjList.addAll(projectList);
        ArrayList<ProjectsManagerData> failedProjects = new ArrayList<ProjectsManagerData>();
        User loggedUser = User.getLoggedUser();
        Object loggedUserId = loggedUser.getId();
        int i = 0;
        while (i < prjList.size()) {
            ProjectsManagerData pmd = (ProjectsManagerData)prjList.get(i);
            ProjectSpaceAllocation spaceAllocation = pmd.getProjectSpaceAllocation();
            ProjectsManagerScope scope = pmd.getScope();
            boolean isAdmin = loggedUser.isAdmin();
            boolean isOwner = pmd.getOwnerId().equals(loggedUserId);
            if (spaceAllocation.isOpenable() && (isAdmin || isOwner) && scope == ProjectsManagerScope.SHARED) {
                ++i;
                continue;
            }
            failedProjects.add(pmd);
            prjList.remove(i);
        }
        ProjectsManager projectsManager = this.getProjectsManager();
        if (prjList.size() == 0) {
            String deniedMessage = String.valueOf(this.getString("AppendUsersAction.project.selection.denied.message")) + this.getString("AppendUsersAction.project.requirements.message");
            StatusDialog.showNoneOkDialog(projectsManager, deniedMessage, failedProjects, this.getString("AppendUsersAction.project.selection.failure.message"));
            return null;
        }
        if (failedProjects.size() > 0 && (res = StatusDialog.showSomeOkDialog(projectsManager, someDeniedMessage = String.valueOf(this.getString("AppendUsersAction.project.selection.some.denied.message")) + this.getString("AppendUsersAction.project.requirements.message"), prjList, this.getString("AppendUsersAction.project.selection.some.failure.message"))) == 0) {
            return null;
        }
        return prjList;
    }

    private void runTask(List<ProjectsManagerData> projects, Set<Object> ids) throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        AppendUsersTask aut = new AppendUsersTask(projectsManager, projects, ids, this.readOnly);
        ApplicationFrame frame = projectsManager.getApplicationFrame();
        aut.execute(frame, projectsManager.getName(), this.getString("AppendUsersAction.message"));
        if (aut.wasCancelled()) {
            String err = this.getString("AppendUsersAction.cancelled.message");
            aut.showError(err);
            return;
        }
        if (!aut.getStatus()) {
            Exception exception = aut.getError();
            throw exception;
        }
        this.updateLocalProjects(projects, ids);
    }

    private void updateLocalProjects(List<ProjectsManagerData> projects, Set<Object> ids) {
        for (ProjectsManagerData pmd : projects) {
            Set<Object> userIds = this.readOnly ? pmd.getUsersRO() : pmd.getUsersRW();
            userIds.addAll(ids);
        }
    }
}

