/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.ProjectStatusModificationDialog;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.StatusModificationTask;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import tecgraf.javautils.gui.StandardDialogs;

public class ChangeStatusAllocateAction
extends ProjectsManagerAction {
    public ChangeStatusAllocateAction(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void actionDone() {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projectList = projectsManager.getSelectedProjects();
        if (projectList == null || projectList.size() <= 0) {
            return;
        }
        List<ProjectsManagerData> projects = this.validateProjects(projectList);
        if (projects == null) {
            return;
        }
        int allocatedSpace = ProjectStatusModificationDialog.openDialog(projectsManager, projects);
        if (allocatedSpace <= 0) {
            return;
        }
        boolean ret = this.runTask(projects, allocatedSpace);
        if (ret) {
            this.updateStatusOfLocalProjects(projects, allocatedSpace);
            projectsManager.refreshProjectsTable();
        } else {
            String errMsg = this.getString("ChangeStatusAllocateAction.error.allocation.message");
            String errTitle = this.getString("ChangeStatusAllocateAction.error.allocation.title");
            StandardDialogs.showErrorDialog((Component)projectsManager.getApplicationFrame(), (String)errTitle, (String)errMsg);
        }
    }

    private void updateStatusOfLocalProjects(List<ProjectsManagerData> projects, int allocatedSpace) {
        for (ProjectsManagerData pmd : projects) {
            pmd.setProjectSpaceAllocation(ProjectSpaceAllocation.ALLOCATED);
            pmd.setRequestedSpace(allocatedSpace);
            pmd.setAllocatedSpace(allocatedSpace);
        }
    }

    private boolean runTask(List<ProjectsManagerData> projects, int allocatedSpace) {
        ProjectsManager projectsManager = this.getProjectsManager();
        ApplicationFrame appFrame = projectsManager.getApplicationFrame();
        StatusModificationTask smt = new StatusModificationTask(projectsManager, projects, ProjectSpaceAllocation.ALLOCATED, allocatedSpace);
        String taskTitle = this.getString("ChangeStatusAllocateAction.running.title");
        String taskMsg = this.getString("ChangeStatusAllocateAction.running.message");
        smt.execute(appFrame, taskTitle, taskMsg);
        if (smt.wasCancelled()) {
            String err = this.getString("ChangeStatusAllocateAction.cancelled.message");
            smt.showError(err);
            return false;
        }
        if (!smt.getStatus()) {
            Exception exception = smt.getError();
            String err = this.getString("ChangeStatusAllocateAction.allocation.status.error.message");
            String msg = String.valueOf(err) + "\n" + exception.getMessage();
            StandardDialogs.showErrorDialog((Component)appFrame, (String)msg, (String)"");
            return false;
        }
        return true;
    }

    @Override
    protected List<ProjectsManagerData> validateProjects(List<ProjectsManagerData> projectList) {
        String someDeniedMessage;
        int res;
        ArrayList<ProjectsManagerData> prjList = new ArrayList<ProjectsManagerData>();
        prjList.addAll(projectList);
        ArrayList<ProjectsManagerData> failedProjects = new ArrayList<ProjectsManagerData>();
        int i = 0;
        while (i < prjList.size()) {
            ProjectsManagerData pmd = (ProjectsManagerData)prjList.get(i);
            ProjectSpaceAllocation spaceAllocation = pmd.getProjectSpaceAllocation();
            if (spaceAllocation != ProjectSpaceAllocation.NO_ALLOCATION) {
                failedProjects.add(pmd);
                prjList.remove(i);
                continue;
            }
            ++i;
        }
        ProjectsManager projectsManager = this.getProjectsManager();
        if (prjList.size() == 0) {
            String deniedMessage = String.valueOf(this.getString("ChangeStatusAllocateAction.project.selection.denied.message")) + this.getString("ChangeStatusAllocateAction.project.requirements.message");
            StatusDialog.showNoneOkDialog(projectsManager, deniedMessage, failedProjects, this.getString("ChangeStatusAllocateAction.project.selection.failure.message"));
            return null;
        }
        if (failedProjects.size() > 0 && (res = StatusDialog.showSomeOkDialog(projectsManager, someDeniedMessage = String.valueOf(this.getString("ChangeStatusAllocateAction.project.selection.some.denied.message")) + this.getString("ChangeStatusAllocateAction.project.requirements.message"), prjList, this.getString("ChangeStatusAllocateAction.project.selection.some.failure.message"))) == 0) {
            return null;
        }
        return prjList;
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return null;
    }
}

