/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.StatusModificationTask;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import tecgraf.javautils.gui.StandardDialogs;

public class ChangeStatusNoAllocationAction
extends ProjectsManagerAction {
    public ChangeStatusNoAllocationAction(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void actionDone() throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projectList = projectsManager.getSelectedProjects();
        if (projectList == null || projectList.size() <= 0) {
            return;
        }
        List<ProjectsManagerData> projects = this.validateProjects(projectList);
        if (projects == null) {
            return;
        }
        int res = JOptionPane.showConfirmDialog(projectsManager.getApplicationFrame(), this.getString("ChangeStatusNoAllocationAction.warning.message"), this.getString("ChangeStatusNoAllocationAction.warning.title"), 2, 2);
        if (res != 0) {
            return;
        }
        boolean ret = this.runTask(projects);
        if (ret) {
            this.updateStatusOfLocalProjects(projects);
            projectsManager.refreshProjectsTable();
        } else {
            String errMsg = this.getString("ChangeStatusNoAllocationAction.error.allocation.message");
            String errTitle = this.getString("ChangeStatusNoAllocationAction.error.allocation.title");
            StandardDialogs.showErrorDialog((Component)projectsManager.getApplicationFrame(), (String)errTitle, (String)errMsg);
        }
    }

    private void updateStatusOfLocalProjects(List<ProjectsManagerData> projects) {
        for (ProjectsManagerData pmd : projects) {
            pmd.setAllocatedSpace(0L);
            pmd.setRequestedSpace(0L);
            pmd.setProjectSpaceAllocation(ProjectSpaceAllocation.NO_ALLOCATION);
        }
    }

    private boolean runTask(List<ProjectsManagerData> projects) {
        ProjectsManager projectsManager = this.getProjectsManager();
        ApplicationFrame appFrame = projectsManager.getApplicationFrame();
        StatusModificationTask smt = new StatusModificationTask(projectsManager, projects);
        String taskTitle = this.getString("ChangeStatusNoAllocationAction.running.title");
        String taskMsg = this.getString("ChangeStatusNoAllocationAction.running.message");
        smt.execute(appFrame, taskTitle, taskMsg);
        if (smt.wasCancelled()) {
            String err = this.getString("ChangeStatusNoAllocationAction.cancelled.message");
            smt.showError(err);
            return false;
        }
        if (!smt.getStatus()) {
            Exception exception = smt.getError();
            String err = this.getString("ChangeStatusNoAllocationAction.allocation.status.error.message");
            String msg = String.valueOf(err) + "\n" + exception.getMessage();
            StandardDialogs.showErrorDialog((Component)appFrame, (String)msg, (String)"");
            return false;
        }
        return true;
    }

    @Override
    protected List<ProjectsManagerData> validateProjects(List<ProjectsManagerData> projectList) {
        String someDeniedMessage;
        int res;
        ArrayList<ProjectsManagerData> prjList = new ArrayList<ProjectsManagerData>();
        prjList.addAll(projectList);
        ArrayList<ProjectsManagerData> failedProjects = new ArrayList<ProjectsManagerData>();
        int i = 0;
        while (i < prjList.size()) {
            ProjectsManagerData pmd = (ProjectsManagerData)prjList.get(i);
            ProjectSpaceAllocation spaceAllocation = pmd.getProjectSpaceAllocation();
            if (spaceAllocation != ProjectSpaceAllocation.ALLOCATED) {
                failedProjects.add(pmd);
                prjList.remove(i);
                continue;
            }
            ++i;
        }
        ProjectsManager projectsManager = this.getProjectsManager();
        if (prjList.size() == 0) {
            String deniedMessage = String.valueOf(this.getString("ChangeStatusNoAllocationAction.project.selection.denied.message")) + this.getString("ChangeStatusNoAllocationAction.project.requirements.message");
            StatusDialog.showNoneOkDialog(projectsManager, deniedMessage, failedProjects, this.getString("ChangeStatusNoAllocationAction.project.selection.failure.message"));
            return null;
        }
        if (failedProjects.size() > 0 && (res = StatusDialog.showSomeOkDialog(projectsManager, someDeniedMessage = String.valueOf(this.getString("ChangeStatusNoAllocationAction.project.selection.some.denied.message")) + this.getString("ChangeStatusNoAllocationAction.project.requirements.message"), prjList, this.getString("ChangeStatusNoAllocationAction.project.selection.some.failure.message"))) == 0) {
            return null;
        }
        return prjList;
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return null;
    }
}

