/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.AllocateAreaTask;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import tecgraf.javautils.gui.StandardDialogs;

public class DeallocateAreaAction
extends ProjectsManagerAction {
    public DeallocateAreaAction(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void actionDone() throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projectList = projectsManager.getSelectedProjects();
        if (projectList == null || projectList.size() <= 0) {
            return;
        }
        List<ProjectsManagerData> projects = this.validateProjects(projectList);
        if (projects == null) {
            return;
        }
        ApplicationFrame appFrame = projectsManager.getApplicationFrame();
        boolean ret = this.runTask(projects);
        if (ret) {
            projectsManager.removeProjects(projects);
            projectsManager.refreshProjectsTable();
        } else {
            String errMsg = this.getString("DeallocateAreaAction.deallocation.error.message");
            String errTitle = this.getString("DeallocateAreaAction.deallocation.error.title");
            StandardDialogs.showErrorDialog((Component)appFrame, (String)errTitle, (String)errMsg);
        }
    }

    private boolean runTask(List<ProjectsManagerData> projects) throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        ApplicationFrame appFrame = projectsManager.getApplicationFrame();
        AllocateAreaTask aat = new AllocateAreaTask(projectsManager, projects, false);
        String taskTitle = this.getString("DeallocateAreaAction.title");
        String taskMsg = this.getString("DeallocateAreaAction.message");
        aat.execute(appFrame, taskTitle, taskMsg);
        if (aat.wasCancelled()) {
            String err = this.getString("DeallocateAreaAction.cancelled.message");
            aat.showError(err);
            return false;
        }
        if (!aat.getStatus()) {
            Exception exception = aat.getError();
            throw exception;
        }
        return (Boolean)aat.getResult();
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ProjectsManagerUI.DEALLOCATED;
    }

    @Override
    protected List<ProjectsManagerData> validateProjects(List<ProjectsManagerData> projectList) {
        String someDeniedMessage;
        int res;
        ArrayList<ProjectsManagerData> prjList = new ArrayList<ProjectsManagerData>();
        prjList.addAll(projectList);
        ArrayList<ProjectsManagerData> failedProjects = new ArrayList<ProjectsManagerData>();
        int i = 0;
        while (i < prjList.size()) {
            ProjectsManagerData pmd = (ProjectsManagerData)prjList.get(i);
            if (pmd.getProjectSpaceAllocation() != ProjectSpaceAllocation.WAITING_DEALLOCATION) {
                failedProjects.add(pmd);
                prjList.remove(i);
                continue;
            }
            ++i;
        }
        ProjectsManager projectsManager = this.getProjectsManager();
        if (prjList.size() == 0) {
            String deniedMessage = String.valueOf(this.getString("DeallocateAreaAction.project.selection.denied.message")) + this.getString("DeallocateAreaAction.project.requirements.message");
            StatusDialog.showNoneOkDialog(projectsManager, deniedMessage, failedProjects, this.getString("DeallocateAreaAction.project.selection.failure.message"));
            return null;
        }
        if (failedProjects.size() > 0 && (res = StatusDialog.showSomeOkDialog(projectsManager, someDeniedMessage = String.valueOf(this.getString("DeallocateAreaAction.project.selection.some.denied.message")) + this.getString("DeallocateAreaAction.project.requirements.message"), prjList, this.getString("DeallocateAreaAction.project.selection.some.failure.message"))) == 0) {
            return null;
        }
        return prjList;
    }
}

