/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.ReplicateSharingDataTask;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.ReplicateSharedDialog;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.logic.ProjectPermissions;
import csbase.logic.User;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class ReplicateSharingDataAction
extends ProjectsManagerAction {
    public ReplicateSharingDataAction(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void actionDone() throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projectList = projectsManager.getSelectedProjects();
        if (projectList == null || projectList.size() == 0) {
            return;
        }
        ApplicationFrame owner = projectsManager.getApplicationFrame();
        if (projectList.size() > 1) {
            StandardDialogs.showInfoDialog((Component)owner, (String)LNG.get((String)"OpenSharingDialogAction.info.dialog.title"), (Object)LNG.get((String)"OpenSharingDialogAction.info.dialog.message"));
            return;
        }
        List<ProjectsManagerData> projects = this.validateProjects(projectList);
        if (projects == null) {
            return;
        }
        ProjectsManagerData sourceProject = projects.get(0);
        ReplicateSharedDialog rsd = new ReplicateSharedDialog(projectsManager, sourceProject);
        rsd.pack();
        rsd.setVisible(true);
        Set<ProjectsManagerData> targetProjects = rsd.getSelectedProjects();
        if (targetProjects == null || targetProjects.size() == 0) {
            return;
        }
        ReplicateSharingDataTask rst = new ReplicateSharingDataTask(projectsManager, sourceProject, targetProjects);
        String title = this.getString("ReplicateSharingDataAction.title");
        String msg = this.getString("ReplicateSharingDataAction.message");
        rst.execute(projectsManager.getApplicationFrame(), title, msg);
        if (rst.wasCancelled()) {
            String err = this.getString("ReplicateSharingDataAction.cancelled.message");
            rst.showError(err);
            return;
        }
        if (!rst.getStatus()) {
            Exception exception = rst.getError();
            throw exception;
        }
        ProjectPermissions.SharingType sharingType = sourceProject.getSharingType();
        Set<Object> uRO = sourceProject.getUsersRO();
        Set<Object> uRW = sourceProject.getUsersRW();
        for (ProjectsManagerData pmd : targetProjects) {
            pmd.setSharingType(sharingType);
            pmd.setUsers(uRO, uRW);
        }
        projectsManager.refreshProjectsTable();
        projectsManager.refreshInfoPanel();
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ApplicationImages.ICON_COPY_16;
    }

    @Override
    protected List<ProjectsManagerData> validateProjects(List<ProjectsManagerData> projectList) {
        User loggedUser = User.getLoggedUser();
        Object loggedUserId = loggedUser.getId();
        ProjectsManagerData pmd = projectList.get(0);
        ProjectSpaceAllocation spaceAllocation = pmd.getProjectSpaceAllocation();
        boolean isAdmin = loggedUser.isAdmin();
        boolean isOwner = pmd.getOwnerId().equals(loggedUserId);
        if (spaceAllocation.isOpenable() && (isAdmin || isOwner)) {
            ArrayList<ProjectsManagerData> l = new ArrayList<ProjectsManagerData>();
            l.add(pmd);
            return l;
        }
        String deniedMessage = String.valueOf(this.getString("ReplicateSharingDataAction.project.selection.denied.message")) + this.getString("ReplicateSharingDataAction.project.requirements.message");
        StatusDialog.showNoneOkDialog(this.getProjectsManager(), deniedMessage, null, this.getString("ReplicateSharingDataAction.project.selection.failure.message"));
        return null;
    }
}

