/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;
import csbase.client.applications.projectsmanager.proxy.SetProjectSharingStatsTask;
import csbase.logic.ProjectPermissions;
import csbase.logic.User;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import tecgraf.javautils.gui.StandardDialogs;

public class SetProjectPrivateAction
extends ProjectsManagerAction {
    public SetProjectPrivateAction(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void actionDone() throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projectList = projectsManager.getSelectedProjects();
        if (projectList == null || projectList.size() <= 0) {
            return;
        }
        ApplicationFrame frame = projectsManager.getApplicationFrame();
        List<ProjectsManagerData> projects = this.validateProjects(projectList);
        if (projects == null) {
            return;
        }
        boolean result = this.runTask(projects);
        if (result) {
            for (ProjectsManagerData pmd : projects) {
                pmd.setSharingType(ProjectPermissions.SharingType.PRIVATE);
            }
            projectsManager.refreshProjectsTable();
            projectsManager.refreshInfoPanel();
        } else {
            String errMsg = this.getString("SetProjectPrivateAction.set.private.error.message");
            String errTitle = this.getString("SetProjectPrivateAction.set.private.error.title");
            StandardDialogs.showErrorDialog((Component)frame, (String)errTitle, (String)errMsg);
        }
    }

    private boolean runTask(List<ProjectsManagerData> projects) throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        ApplicationFrame frame = projectsManager.getApplicationFrame();
        SetProjectSharingStatsTask fptt = new SetProjectSharingStatsTask(projectsManager, projects, ProjectsManagerScope.PRIVATE, ProjectPermissions.SharingType.PRIVATE);
        fptt.execute(frame, this.getString("SetProjectPrivateAction.title"), this.getString("SetProjectPrivateAction.message"));
        if (fptt.wasCancelled()) {
            String err = this.getString("SetProjectPrivateAction.cancelled.message");
            fptt.showError(err);
            return false;
        }
        if (!fptt.getStatus()) {
            Exception exception = fptt.getError();
            throw exception;
        }
        return (Boolean)fptt.getResult();
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ApplicationImages.ICON_PRIVATE_16;
    }

    @Override
    protected List<ProjectsManagerData> validateProjects(List<ProjectsManagerData> projectList) {
        String someDeniedMessage;
        int res;
        ArrayList<ProjectsManagerData> prjList = new ArrayList<ProjectsManagerData>();
        prjList.addAll(projectList);
        ArrayList<ProjectsManagerData> failedProjects = new ArrayList<ProjectsManagerData>();
        User loggedUser = User.getLoggedUser();
        Object loggedUserId = loggedUser.getId();
        int i = 0;
        while (i < prjList.size()) {
            ProjectsManagerData pmd = (ProjectsManagerData)prjList.get(i);
            ProjectSpaceAllocation spaceAllocation = pmd.getProjectSpaceAllocation();
            boolean isAdmin = loggedUser.isAdmin();
            boolean isOwner = pmd.getOwnerId().equals(loggedUserId);
            if (spaceAllocation.isOpenable() && (isAdmin || isOwner)) {
                ++i;
                continue;
            }
            failedProjects.add(pmd);
            prjList.remove(i);
        }
        ProjectsManager projectsManager = this.getProjectsManager();
        if (prjList.size() == 0) {
            String deniedMessage = String.valueOf(this.getString("SetProjectPrivateAction.project.selection.denied.message")) + this.getString("SetProjectPrivateAction.project.requirements.message");
            StatusDialog.showNoneOkDialog(projectsManager, deniedMessage, failedProjects, this.getString("SetProjectPrivateAction.project.selection.failure.message"));
            return null;
        }
        if (failedProjects.size() > 0 && (res = StatusDialog.showSomeOkDialog(projectsManager, someDeniedMessage = String.valueOf(this.getString("SetProjectPrivateAction.project.selection.some.denied.message")) + this.getString("SetProjectPrivateAction.project.requirements.message"), prjList, this.getString("SetProjectPrivateAction.project.selection.some.failure.message"))) == 0) {
            return null;
        }
        return prjList;
    }
}

