/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.GetProjectHistoryTask;
import csbase.client.facilities.textviewer.TextViewer;
import csbase.logic.User;
import javax.swing.ImageIcon;

public class ShowProjectHistoryAction
extends ProjectsManagerAction {
    public ShowProjectHistoryAction(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ApplicationImages.ICON_LIST_16;
    }

    @Override
    public void actionDone() throws Exception {
        ProjectsManagerData pmd = this.getProjectsManager().getSelectedProjects().get(0);
        if (!this.validateProject(pmd)) {
            String deniedMessage = String.valueOf(this.getString("ShowProjectHistoryAction.project.selection.denied.message")) + this.getString("ShowProjectHistoryAction.project.requirements.message");
            StatusDialog.showNoneOkDialog(this.getProjectsManager(), deniedMessage, pmd, this.getString("ShowProjectHistoryAction.project.selection.failure.message"));
            return;
        }
        String projectName = pmd.getProjectName();
        GetProjectHistoryTask task = new GetProjectHistoryTask(this.getProjectsManager(), pmd);
        String taskMsgTemplate = this.getString("ShowProjectHistoryAction.retrieving.history.message");
        String taskMsg = String.format(taskMsgTemplate, projectName);
        String taskTitle = this.getString("ShowProjectHistoryAction.retrieving.history.title");
        ApplicationFrame owner = this.getProjectsManager().getApplicationFrame();
        task.execute(owner, taskTitle, taskMsg);
        if (task.wasCancelled()) {
            String taskCancelled = this.getString("ShowProjectHistoryAction.retrieving.history.cancelled.message");
            task.showError(taskCancelled);
            return;
        }
        if (!task.getStatus()) {
            Exception exception = task.getError();
            throw exception;
        }
        String history = (String)task.getResult();
        String viewerTitleTemplate = this.getString("ShowProjectHistoryAction.showing.history.title");
        String viewerTitle = String.format(viewerTitleTemplate, projectName);
        TextViewer textViewer = new TextViewer(history, viewerTitle);
        textViewer.showDialog();
    }

    protected boolean validateProject(ProjectsManagerData pmd) {
        User loggedUser = User.getLoggedUser();
        Object loggedUserId = loggedUser.getId();
        ProjectSpaceAllocation spaceAllocation = pmd.getProjectSpaceAllocation();
        if (!spaceAllocation.isOpenable()) {
            return false;
        }
        if (loggedUser.isAdmin()) {
            return true;
        }
        if (pmd.getOwnerId().equals(loggedUserId)) {
            return true;
        }
        switch (pmd.getSharingType()) {
            case PRIVATE: {
                return false;
            }
            case PARTIAL: {
                return pmd.getUsersRO().contains(loggedUserId) || pmd.getUsersRW().contains(loggedUserId);
            }
            case ALL_RO: 
            case ALL_RW: {
                return true;
            }
        }
        String[] queue = new String[]{this.getClass().getSimpleName()};
        String[] info = new String[]{"[ERRO] N\u00e3o existe a valida\u00e7\u00e3o para projetos com compartilhamento " + pmd.getSharingType().name() + " n\u00e3o foi encontrada."};
        this.getProjectsManager().logDetailedApplicationEvent(queue, info);
        return false;
    }
}

