/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.dialogs;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.dialogs.core.ProjectsManagerDialog;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.ProjectSharingInfoPanel;
import csbase.client.applications.projectsmanager.proxy.AdminSendEmailTask;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;

public class AdminMailDialog
extends ProjectsManagerDialog {
    private List<ProjectsManagerData> projectsManagerData;
    private final JTextField subjectField = new JTextField();
    private final JTextArea mailArea = new JTextArea();

    public AdminMailDialog(ProjectsManager projectsManager, List<ProjectsManagerData> projectsManagerData) {
        super(projectsManager);
        this.projectsManagerData = projectsManagerData;
        this.buildPanel();
        this.setTitle(this.getString("AdminMailDialog.title"));
    }

    private JPanel buildButtonsPanel() {
        JButton sendButton = new JButton();
        JButton cancelButton = new JButton();
        final AdminMailDialog amd = this;
        sendButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] ret;
                ProjectsManager projectsManager = AdminMailDialog.this.getProjectsManager();
                Map userProjectMap = AdminMailDialog.this.generateUserProjectMap();
                AdminSendEmailTask aset = new AdminSendEmailTask(projectsManager, userProjectMap, AdminMailDialog.this.subjectField.getText(), AdminMailDialog.this.mailArea.getText());
                ApplicationFrame appFrame = projectsManager.getApplicationFrame();
                String taskTitle = projectsManager.getName();
                String taskMsg = AdminMailDialog.this.getString("AdminMailDialog.running.message");
                aset.execute(appFrame, taskTitle, taskMsg);
                if (aset.wasCancelled()) {
                    String err = AdminMailDialog.this.getString("AdminMailDialog.cancelled.message");
                    aset.showError(err);
                    return;
                }
                if (!aset.getStatus()) {
                    Exception exception = aset.getError();
                    String err = AdminMailDialog.this.getString("AdminMailDialog.send.mail.error.message");
                    StringBuilder strBuilder = new StringBuilder(err);
                    strBuilder.append("\n");
                    strBuilder.append(exception.getMessage());
                    StandardDialogs.showErrorDialog((Component)appFrame, (String)"", (String)strBuilder.toString());
                }
                if ((ret = (String[])aset.getResult()) != null) {
                    if (ret.length == 0) {
                        String errMsg = AdminMailDialog.this.getString("AdminMailDialog.user.mail.error");
                        StandardDialogs.showErrorDialog((Component)appFrame, (String)"", (String)errMsg);
                        return;
                    }
                    StringBuilder users = new StringBuilder();
                    String[] stringArray = ret;
                    int n = ret.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String str = stringArray[n2];
                        users.append(" - " + str + "\n");
                        ++n2;
                    }
                    String err = AdminMailDialog.this.getString("AdminMailDialog.failure.sending.mail.message");
                    String errMsg = AdminMailDialog.this.getString("AdminMailDialog.failure.sending.mail.complement.message");
                    StringBuilder msg = new StringBuilder(err);
                    msg.append("\n" + users.toString() + "\n" + errMsg);
                    StandardDialogs.showErrorDialog((Component)appFrame, (String)projectsManager.getName(), (String)msg.toString());
                }
                amd.dispose();
            }
        });
        sendButton.setText(this.getString("AdminMailDialog.send.text"));
        cancelButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                amd.dispose();
            }
        });
        cancelButton.setText(this.getString("AdminMailDialog.cancel.text"));
        JComponent[] buttons = new JComponent[]{sendButton, cancelButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(sendButton);
        buttonsPanel.add(cancelButton);
        return buttonsPanel;
    }

    private Map<Object, Set<String>> generateUserProjectMap() {
        HashMap<Object, Set<String>> userProjectMap = new HashMap<Object, Set<String>>();
        for (ProjectsManagerData pmd : this.projectsManagerData) {
            HashSet<String> aux = (HashSet<String>)userProjectMap.get(pmd.getOwnerId());
            if (aux == null) {
                aux = new HashSet<String>();
            }
            aux.add(pmd.getProjectName());
            userProjectMap.put(pmd.getOwnerId(), aux);
        }
        return userProjectMap;
    }

    private JScrollPane buildTextPane() {
        this.mailArea.setRows(5);
        this.mailArea.setColumns(40);
        this.mailArea.setLineWrap(true);
        JScrollPane pane = new JScrollPane(this.mailArea);
        BorderUtil.setTitledBorder((JComponent)pane, (String)this.getString("AdminMailDialog.mail.area.title"));
        return pane;
    }

    private ProjectSharingInfoPanel buildProjectPanel() {
        ProjectsManager projectsManager = this.getProjectsManager();
        ProjectSharingInfoPanel projectsPanel = new ProjectSharingInfoPanel(projectsManager, this.projectsManagerData, false, true);
        BorderUtil.setTitledBorder((JComponent)projectsPanel, (String)this.getString("AdminMailDialog.projects.title"));
        return projectsPanel;
    }

    private void buildPanel() {
        JPanel buttonsPanel = this.buildButtonsPanel();
        JPanel subjectPanel = this.buildSubjectPanel();
        JScrollPane pane = this.buildTextPane();
        ProjectSharingInfoPanel projectsPanel = this.buildProjectPanel();
        this.setLayout(new GridBagLayout());
        this.add((Component)projectsPanel, new GBC(0, 0).horizontal());
        this.add((Component)subjectPanel, new GBC(0, 1).horizontal());
        this.add((Component)pane, new GBC(0, 2).both());
        this.add((Component)buttonsPanel, new GBC(0, 3).horizontal());
    }

    private JPanel buildSubjectPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.subjectField, new GBC(0, 0).horizontal());
        BorderUtil.setTitledBorder((JComponent)panel, (String)this.getString("AdminMailDialog.subject.title"));
        return panel;
    }
}

