/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.dialogs;

import csbase.client.applicationmanager.resourcehelpers.ApplicationUtils;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.dialogs.core.ProjectsManagerDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.models.SearchResultTableModel;
import csbase.client.applications.projectsmanager.panels.ProjectSharingInfoPanel;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.FileInfoSearchResult;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.StatusBar;
import tecgraf.javautils.gui.SwingThreadDispatcher;
import tecgraf.javautils.gui.table.SortableTable;

public class SearchFilesDialog
extends ProjectsManagerDialog {
    private static final Color READONLY_BG = UIManager.getColor("Panel.background");
    private static final Color READWRITE_BG = UIManager.getColor("Table.background");
    private static final Color SELECTION_BG = UIManager.getColor("Table.selectionBackground");
    private static final Color SELECTION_BG_DARK = new Color(154, 177, 199);
    private List<ProjectsManagerData> selectedProjectList;
    private final List<ProjectsManagerData> allProjectList;
    private JRadioButton allProjectsButton;
    private JRadioButton selectedProjectsButton;
    private JTextField nameTextField;
    private JLabel infoNameTextField;
    private final String infoDefaultMessage = this.getString("SearchFilesDialog.info.default");
    private final String READONLY_TOOLTIP = this.getString("SearchFilesDialog.tooltip.suffix.readOnly");
    private final String infoRegexErrorMessage = this.getString("SearchFilesDialog.info.regex.error");
    private JCheckBox ignoreCheckBox;
    private JCheckBox regexCheckBox;
    private SortableTable resultTable;
    private JButton searchButton;
    private JButton closeButton;
    private final boolean useAllProjectsList;
    private StatusBar statusBar;

    public SearchFilesDialog(ProjectsManager projectsManager, List<ProjectsManagerData> selectedProjectList, List<ProjectsManagerData> allProjectList, boolean useAllProjectsList) {
        super(projectsManager);
        this.selectedProjectList = selectedProjectList;
        this.allProjectList = allProjectList;
        this.useAllProjectsList = useAllProjectsList;
        this.statusBar = new StatusBar();
        this.buildPanel();
        this.statusBar.showStatusBar();
        this.setTitle(this.getString("SearchFilesDialog.title"));
        this.nameTextField.requestFocusInWindow();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add((Component)this.buildProjectsPanel(), new GBC(0, y++).horizontal());
        this.add((Component)new JSeparator(0), new GBC(0, y++).fillx().insets(10));
        this.add((Component)this.buildInputPanel(), new GBC(0, y++).horizontal().insets(0, 10, 0, 10));
        this.add((Component)this.buildResultScrollPane(), new GBC(0, y++).both().insets(10, 10, 0, 10));
        this.add((Component)this.statusBar, new GBC(0, y++).horizontal().insets(0, 10, 10, 10).bottom(10).top(5));
        this.add((Component)this.buildButtonPanel(), new GBC(0, y++).horizontal().bottom(5));
    }

    private JPanel buildProjectsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        String label = this.getProjectsManager().isFilterOn() ? this.getString("SearchFilesDialog.radio.filteredProjects") : this.getString("SearchFilesDialog.radio.allProjects");
        this.allProjectsButton = new JRadioButton(label, this.useAllProjectsList);
        this.selectedProjectsButton = new JRadioButton(this.getString("SearchFilesDialog.radio.selectedProjects"), !this.useAllProjectsList);
        this.selectedProjectsButton.setEnabled(!this.useAllProjectsList);
        ButtonGroup group = new ButtonGroup();
        group.add(this.allProjectsButton);
        group.add(this.selectedProjectsButton);
        GBC gbc = new GBC(0, 0).northwest().insets(10, 10, 0, 10);
        panel.add((Component)this.allProjectsButton, gbc);
        gbc = new GBC(0, 1).northwest().insets(0, 10, 0, 10);
        panel.add((Component)this.selectedProjectsButton, gbc);
        ProjectsManager projectsManager = this.getProjectsManager();
        ProjectSharingInfoPanel projectsPanel = new ProjectSharingInfoPanel(projectsManager, this.selectedProjectList, true, false);
        gbc = new GBC(0, 2).northwest().insets(5, 30, 10, 10).horizontal().weightx(1.0);
        panel.add((Component)projectsPanel, gbc);
        return panel;
    }

    private JPanel buildInputPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GBC gbc = new GBC(0, 0).west();
        panel.add((Component)new JLabel(this.getString("SearchFilesDialog.fileName")), gbc);
        gbc = new GBC(1, 0).west().insets(5, 5, 0, 0).horizontal();
        this.nameTextField = new JTextField(10);
        this.nameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (SearchFilesDialog.this.regexCheckBox.isSelected()) {
                    SearchFilesDialog.this.checkRegex();
                }
            }
        });
        this.nameTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SearchFilesDialog.this.nameTextField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                SearchFilesDialog.this.nameTextField.select(0, 0);
            }
        });
        panel.add((Component)this.nameTextField, gbc);
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SearchFilesDialog.this.nameTextField.requestFocusInWindow();
            }
        });
        gbc = new GBC(1, 1).northwest().insets(0, 5, 0, 0);
        this.infoNameTextField = new JLabel(this.infoDefaultMessage);
        Font tipFont = this.infoNameTextField.getFont().deriveFont(0, this.infoNameTextField.getFont().getSize() - 1);
        this.infoNameTextField.setFont(tipFont);
        panel.add((Component)this.infoNameTextField, gbc);
        gbc = new GBC(2, 0).northwest().insets(5, 10, 0, 0);
        this.ignoreCheckBox = new JCheckBox(this.getString("SearchFilesDialog.check.ignore"), true);
        panel.add((Component)this.ignoreCheckBox, gbc);
        gbc = new GBC(2, 1).northwest().insets(0, 10, 0, 0);
        this.regexCheckBox = new JCheckBox(this.getString("SearchFilesDialog.check.regex"));
        this.regexCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchFilesDialog.this.checkInput();
            }
        });
        panel.add((Component)this.regexCheckBox, gbc);
        gbc = new GBC(3, 0).east().insets(5, 10, 0, 0);
        this.searchButton = new JButton(new AbstractAction(this.getString("SearchFilesDialog.searchButton")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchFilesDialog.this.searchFiles();
            }
        });
        panel.add((Component)this.searchButton, gbc);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.nameTextField.getInputMap().put(keyStroke, "doSearch");
        this.nameTextField.getActionMap().put("doSearch", this.searchButton.getAction());
        return panel;
    }

    private void checkRegex() {
        String text = this.nameTextField.getText();
        boolean validPattern = true;
        try {
            Pattern.compile(text);
        }
        catch (PatternSyntaxException pse) {
            validPattern = false;
        }
        if (validPattern) {
            this.infoNameTextField.setText("");
        } else {
            this.infoNameTextField.setText(this.infoRegexErrorMessage);
        }
        this.searchButton.setEnabled(validPattern);
    }

    private void checkInput() {
        if (this.regexCheckBox.isSelected()) {
            this.checkRegex();
        } else {
            this.infoNameTextField.setText(this.infoDefaultMessage);
            this.searchButton.setEnabled(true);
        }
    }

    private JScrollPane buildResultScrollPane() {
        this.resultTable = new SortableTable(){

            public String getToolTipText(MouseEvent e) {
                String ret = null;
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                ret = (String)this.getValueAt(rowIndex, colIndex);
                SearchResultTableModel model = (SearchResultTableModel)SearchFilesDialog.this.resultTable.getModel();
                boolean writable = model.isWritable(SearchFilesDialog.this.resultTable.convertRowIndexToModel(rowIndex));
                if (!writable) {
                    ret = String.valueOf(ret) + SearchFilesDialog.this.READONLY_TOOLTIP;
                }
                return ret;
            }
        };
        this.resultTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SearchFilesDialog.this.handleDoubleClick();
                }
            }
        });
        String[] colNames = new String[]{"#", this.getString("SearchFilesDialog.column.file"), this.getString("SearchFilesDialog.column.project"), this.getString("SearchFilesDialog.column.path"), this.getString("SearchFilesDialog.column.owner")};
        this.resultTable.setModel((TableModel)new SearchResultTableModel(colNames));
        this.resultTable.setNoSortStateEnabled(true);
        this.resultTable.setAutoResizeMode(4);
        TableColumnModel columnModel = this.resultTable.getColumnModel();
        TableColumn column0 = columnModel.getColumn(0);
        TableColumn column1 = columnModel.getColumn(1);
        TableColumn column2 = columnModel.getColumn(2);
        TableColumn column3 = columnModel.getColumn(3);
        TableColumn column4 = columnModel.getColumn(4);
        column0.setPreferredWidth(10);
        column1.setPreferredWidth(225);
        column2.setPreferredWidth(50);
        column3.setPreferredWidth(125);
        column4.setPreferredWidth(50);
        this.configureDefaultRenderer();
        JScrollPane scrollTable = new JScrollPane((Component)this.resultTable);
        return scrollTable;
    }

    private void configureDefaultRenderer() {
        this.resultTable.setDefaultRenderer(String.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                SearchResultTableModel model = (SearchResultTableModel)SearchFilesDialog.this.resultTable.getModel();
                boolean writable = model.isWritable(SearchFilesDialog.this.resultTable.convertRowIndexToModel(row));
                if (isSelected) {
                    component.setBackground(writable ? SELECTION_BG : SELECTION_BG_DARK);
                } else {
                    component.setBackground(writable ? READWRITE_BG : READONLY_BG);
                }
                return component;
            }

            @Override
            public boolean isOpaque() {
                return true;
            }
        });
    }

    private JPanel buildButtonPanel() {
        JPanel panel = new JPanel();
        this.closeButton = new JButton(this.getString("SearchFilesDialog.closeButton"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchFilesDialog.this.dispose();
            }
        });
        panel.add(this.closeButton);
        return panel;
    }

    private void searchFiles() {
        final String text = this.nameTextField.getText();
        final boolean isCaseInsensitive = this.ignoreCheckBox.isSelected();
        final boolean isRegex = this.regexCheckBox.isSelected();
        SearchResultTableModel model = (SearchResultTableModel)this.resultTable.getModel();
        model.resetList();
        ApplicationFrame appFrame = this.getProjectsManager().getApplicationFrame();
        String taskTitle = this.getString("SearchFilesDialog.running.title");
        String taskMessage = this.getString("SearchFilesDialog.running.message");
        List<ProjectsManagerData> projects = this.allProjectsButton.isSelected() ? this.allProjectList : this.selectedProjectList;
        int count = 0;
        for (final ProjectsManagerData project : projects) {
            ProjectSpaceAllocation projectSpaceAllocation = project.getProjectSpaceAllocation();
            if (projectSpaceAllocation == ProjectSpaceAllocation.WAITING_ALLOCATION || projectSpaceAllocation == ProjectSpaceAllocation.WAITING_DEALLOCATION) continue;
            RemoteTask<Collection<FileInfoSearchResult>> task = new RemoteTask<Collection<FileInfoSearchResult>>(){

                protected void performTask() throws Exception {
                    ProjectServiceInterface psi = ClientRemoteLocator.projectService;
                    List data = psi.getAllFileInfoSearchResult(project.getProjectId(), text, isCaseInsensitive, isRegex);
                    this.setResult(data);
                }
            };
            List filesList = task.execute(appFrame, taskTitle, String.format(taskMessage, project.getProjectName()), 0, 0) ? (List)task.getResult() : null;
            if (task.wasCancelled()) break;
            if (filesList == null || filesList.isEmpty()) continue;
            model.addAll(filesList);
            count += filesList.size();
        }
        String msg = this.getString("SearchFilesDialog.statusBar.message");
        this.statusBar.setStatus(String.format(msg, count));
    }

    public void handleDoubleClick() {
        int selectedRow = this.resultTable.getSelectedRow();
        String fileName = (String)this.resultTable.getValueAt(selectedRow, 1);
        Object projectId = ((SearchResultTableModel)this.resultTable.getModel()).getProjectId(this.resultTable.convertRowIndexToModel(selectedRow));
        String dirPath = (String)this.resultTable.getValueAt(selectedRow, 3);
        String[] filePath = ClientProjectFile.splitPath((String)(String.valueOf(dirPath) + "/" + fileName));
        CommonClientProject project = DesktopFrame.getInstance().getProject();
        if (project == null) {
            project = DesktopFrame.getInstance().openProject(projectId);
            DesktopFrame.getInstance().setCurrentProject(project);
        } else if (!project.getId().equals(projectId)) {
            int answer = StandardDialogs.showYesNoDialog((Component)this.getProjectsManager().getApplicationFrame(), (String)this.getString("SearchFilesDialog.openProject.dialog.title"), (Object)this.getString("SearchFilesDialog.openProject.dialog.message"));
            if (answer != 0) {
                return;
            }
            project = DesktopFrame.getInstance().openProject(projectId);
            DesktopFrame.getInstance().setCurrentProject(project);
        }
        try {
            ClientProjectFile file = project.getFile(filePath);
            ApplicationUtils.runPreferredApp(this, file);
        }
        catch (Exception e) {
            StandardErrorDialogs.showErrorDialog((Window)this.getProjectsManager().getApplicationFrame(), e);
        }
    }
}

