/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.AbstractProjectManagerInfoPanel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GBC;

class MultipleSelectionPanel
extends AbstractProjectManagerInfoPanel {
    private List<ProjectsManagerData> projectsManagerData;
    private JTextField numberOfProjectsText;
    private JTextField projectsSizeText;
    private JTextField projectsSpaceText;

    MultipleSelectionPanel(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    void initComponents() {
        this.numberOfProjectsText = new JTextField();
        this.projectsSizeText = new JTextField();
        this.projectsSpaceText = new JTextField();
        this.numberOfProjectsText.setEditable(false);
        this.numberOfProjectsText.setHorizontalAlignment(4);
        this.projectsSizeText.setEditable(false);
        this.projectsSizeText.setHorizontalAlignment(4);
        this.projectsSpaceText.setEditable(false);
        this.projectsSpaceText.setHorizontalAlignment(4);
    }

    @Override
    void buildPanel() {
        int T = 12;
        int TI = 6;
        int L = 12;
        int B = 17;
        int R = 11;
        this.setLayout(new GridBagLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel numOfProjectsLabel = new JLabel(this.getString("MultipleSelectionPanel.project.number.of.projects.label"));
        JLabel projectsSizeLabel = new JLabel(this.getString("MultipleSelectionPanel.project.allocated.space.label"));
        JLabel projectsSpaceLabel = new JLabel(this.getString("MultipleSelectionPanel.project.occupied.space.label"));
        panel.add((Component)numOfProjectsLabel, new GBC(0, 0).west().insets(12, 12, 0, 11));
        panel.add((Component)this.numberOfProjectsText, new GBC(1, 0).west().insets(12, 12, 0, 11).horizontal());
        panel.add((Component)projectsSizeLabel, new GBC(0, 1).west().insets(6, 12, 0, 11));
        panel.add((Component)this.projectsSizeText, new GBC(1, 1).west().insets(6, 12, 0, 11).horizontal());
        panel.add((Component)projectsSpaceLabel, new GBC(0, 2).west().insets(6, 12, 17, 11));
        panel.add((Component)this.projectsSpaceText, new GBC(1, 2).west().insets(6, 12, 17, 11).horizontal());
        BorderUtil.setTitledBorder((JComponent)this, (String)this.getString("MultipleSelectionPanel.project.info.title"));
        this.add((Component)panel, new GBC(0, 0).horizontal(1.0));
        this.add((Component)new JPanel(), new GBC(1, 0).horizontal(3.0));
        this.validate();
        this.repaint();
    }

    @Override
    void updateFields() {
        String unit;
        this.numberOfProjectsText.setText(String.valueOf(this.projectsManagerData.size()));
        this.projectsSizeText.setText(String.valueOf(String.valueOf(this.calculateSummedUpAllocatedSpace())) + " " + this.getString("MultipleSelectionPanel.GBytes"));
        double occupation = this.calculateSummedUpOccupiedSpace();
        if (occupation > 1024.0) {
            occupation /= 1024.0;
            unit = this.getString("MultipleSelectionPanel.GBytes");
        } else {
            unit = this.getString("MultipleSelectionPanel.MBytes");
        }
        occupation = (double)Math.round(occupation * 1000.0) / 1000.0;
        this.projectsSpaceText.setText(String.valueOf(String.valueOf(occupation)) + " " + unit);
    }

    @Override
    public void clearFields() {
        this.numberOfProjectsText.setText(null);
        this.projectsSizeText.setText(null);
        this.projectsSpaceText.setText(null);
    }

    private double calculateSummedUpAllocatedSpace() {
        double total = 0.0;
        for (ProjectsManagerData pmd : this.projectsManagerData) {
            double aux = pmd.getAllocatedSpace();
            total += aux;
        }
        return total;
    }

    private double calculateSummedUpOccupiedSpace() {
        double total = 0.0;
        for (ProjectsManagerData pmd : this.projectsManagerData) {
            double aux = pmd.getOccupiedSpace();
            if (!(aux > 0.0)) continue;
            total += aux;
        }
        return total;
    }

    public void setProjectsManagerData(List<ProjectsManagerData> projectsManagerData) {
        this.projectsManagerData = projectsManagerData;
        this.updateFields();
    }
}

