/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.ProjectsManagerPanel;
import csbase.client.applications.projectsmanager.panels.SimpleTableModel;
import csbase.client.applications.projectsmanager.panels.renderers.ServerLocationRenderer;
import csbase.client.applications.projectsmanager.panels.renderers.TableAllocationRenderer;
import csbase.client.applications.projectsmanager.panels.renderers.TableDateRenderer;
import csbase.client.applications.projectsmanager.panels.renderers.TableOccupationRenderer;
import csbase.client.applications.projectsmanager.panels.renderers.TableScopeRenderer;
import csbase.client.applications.projectsmanager.panels.renderers.TableSpaceAllocationRenderer;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.RowSorter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.table.SortableTable;

public class TablePanel
extends ProjectsManagerPanel {
    private final SortableTable projectsTable = new SortableTable();
    private List<ProjectsManagerData> visibleProjects = new ArrayList<ProjectsManagerData>();

    public TablePanel(ProjectsManager projectsManager) {
        super(projectsManager);
        this.initComponents();
        this.buildPanel();
        this.addSelectionListeners();
        this.defineColumns();
        this.setVisible(true);
        this.validate();
        this.repaint();
    }

    private void addSelectionListeners() {
        this.projectsTable.setSelectionMode(2);
        this.projectsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ProjectsManager projectsManager = TablePanel.this.getProjectsManager();
                projectsManager.setSelectedProjectsList(TablePanel.this.getSelectedProjects());
            }
        });
    }

    private void defineColumns() {
        this.projectsTable.setAutoResizeMode(3);
        TableColumnModel columnModel = this.projectsTable.getColumnModel();
        TableColumn column0 = columnModel.getColumn(0);
        column0.setHeaderValue(this.getString("TablePanel.project.access.tablecolumn"));
        column0.setCellRenderer(new TableScopeRenderer());
        column0.setPreferredWidth(50);
        ProjectsManager projectsManager = this.getProjectsManager();
        boolean areaReserved = projectsManager.hasAreaReserved();
        int idx = 1;
        if (areaReserved) {
            TableColumn column1 = columnModel.getColumn(idx);
            column1.setHeaderValue(this.getString("TablePanel.project.allocation.tablecolumn"));
            column1.setCellRenderer(new TableSpaceAllocationRenderer());
            column1.setPreferredWidth(50);
            TableColumn column2 = columnModel.getColumn(++idx);
            column2.setHeaderValue(this.getString("TablePanel.allocated.space.tablecolumn"));
            column2.setCellRenderer(new TableAllocationRenderer());
            column2.setPreferredWidth(90);
            ++idx;
        }
        TableColumn column3 = columnModel.getColumn(idx);
        column3.setHeaderValue(this.getString("TablePanel.project.name.tablecolumn"));
        column3.setPreferredWidth(170);
        TableColumn column4 = columnModel.getColumn(++idx);
        column4.setHeaderValue(this.getString("TablePanel.owner.name.tablecolumn"));
        column4.setPreferredWidth(60);
        TableColumn column5 = columnModel.getColumn(++idx);
        column5.setHeaderValue(this.getString("TablePanel.occupied.space.tablecolumn"));
        column5.setCellRenderer(new TableOccupationRenderer());
        column5.setPreferredWidth(90);
        TableColumn column6 = columnModel.getColumn(++idx);
        column6.setHeaderValue(this.getString("TablePanel.creation.date.tablecolumn"));
        column6.setCellRenderer(new TableDateRenderer());
        column6.setPreferredWidth(160);
        TableColumn column7 = columnModel.getColumn(++idx);
        column7.setHeaderValue(this.getString("TablePanel.last.used.date.tablecolumn"));
        column7.setCellRenderer(new TableDateRenderer());
        column7.setPreferredWidth(160);
        TableColumn column8 = columnModel.getColumn(++idx);
        column8.setHeaderValue(this.getString("TablePanel.server.name.tablecolumn"));
        column8.setPreferredWidth(160);
        ++idx;
        if (areaReserved) {
            TableColumn column9 = columnModel.getColumn(idx);
            column9.setHeaderValue(this.getString("TablePanel.server.location.tablecolumn"));
            column9.setCellRenderer(new ServerLocationRenderer());
            column9.setPreferredWidth(250);
            ++idx;
        }
    }

    public List<ProjectsManagerData> getSelectedProjects() {
        int[] rows = this.projectsTable.getSelectedRows();
        ArrayList<ProjectsManagerData> projectsManagerData = new ArrayList<ProjectsManagerData>();
        int i = 0;
        while (i < rows.length) {
            projectsManagerData.add(this.visibleProjects.get(this.projectsTable.convertRowIndexToModel(rows[i])));
            ++i;
        }
        return projectsManagerData;
    }

    private void initComponents() {
        this.projectsTable.setNoSortStateEnabled(true);
        SimpleTableModel stm = new SimpleTableModel(this);
        this.projectsTable.setModel((TableModel)stm);
        this.projectsTable.setUpdateSelectionOnSort(true);
        ProjectsManager projectsManager = this.getProjectsManager();
        if (!projectsManager.hasAreaReserved()) {
            TableColumnModel model = this.projectsTable.getColumnModel();
            TableColumn column1 = model.getColumn(1);
            TableColumn column2 = model.getColumn(2);
            TableColumn column9 = model.getColumn(9);
            model.removeColumn(column1);
            model.removeColumn(column2);
            model.removeColumn(column9);
        }
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        JScrollPane projectsTablePane = new JScrollPane((Component)this.projectsTable);
        this.add((Component)projectsTablePane, new GBC(0, 0).both());
    }

    public void addProjectToTable(ProjectsManagerData prj) {
        if (prj == null) {
            return;
        }
        RowSorter rs = this.projectsTable.getRowSorter();
        List<RowSorter.SortKey> l = rs.getSortKeys();
        rs.setSortKeys(null);
        this.visibleProjects.add(prj);
        rs.setSortKeys(l);
        this.refreshTable();
    }

    public void removeProjectFromTable(ProjectsManagerData pmd) {
        if (pmd == null) {
            return;
        }
        RowSorter rs = this.projectsTable.getRowSorter();
        List<RowSorter.SortKey> l = rs.getSortKeys();
        rs.setSortKeys(null);
        this.visibleProjects.remove(pmd);
        rs.setSortKeys(l);
        this.refreshTable();
    }

    public final void emptyTableData() {
        this.projectsTable.clearSelection();
        ProjectsManager projectsManager = this.getProjectsManager();
        projectsManager.clearInfoFields();
        this.visibleProjects.clear();
        this.refreshTable();
    }

    public void refreshTable() {
        this.projectsTable.revalidate();
        this.projectsTable.repaint();
    }

    public final void setVisibleProjects(List<ProjectsManagerData> projects) {
        RowSorter rs = this.projectsTable.getRowSorter();
        List<RowSorter.SortKey> l = rs.getSortKeys();
        rs.setSortKeys(null);
        this.visibleProjects.clear();
        this.visibleProjects.addAll(projects);
        rs.setSortKeys(l);
    }

    public final List<ProjectsManagerData> getVisibleProjects() {
        return this.visibleProjects;
    }

    public final void setTableSelectionInterval(int idx0, int idx1) {
        this.projectsTable.getSelectionModel().setSelectionInterval(idx0, idx1);
    }

    public void clearTableSelection() {
        this.projectsTable.clearSelection();
    }
}

