/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels.filters;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.ProjectsManagerPanel;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextField;
import tecgraf.javautils.gui.StandardDialogs;

public abstract class AbstractProjectFilter
extends ProjectsManagerPanel {
    protected AbstractProjectFilter(ProjectsManager projectsManager) {
        super(projectsManager);
        this.initComponents();
        this.buildPanel();
    }

    protected abstract void initComponents();

    protected abstract void buildPanel();

    public abstract boolean projectMatchesFilter(ProjectsManagerData var1);

    public List<ProjectsManagerData> runFilter(List<ProjectsManagerData> allProjects, boolean refresh) {
        ArrayList<ProjectsManagerData> filtered = new ArrayList<ProjectsManagerData>();
        this.runSpecificFilter(allProjects, filtered);
        ProjectsManager projectsManager = this.getProjectsManager();
        projectsManager.setFilteredProjects(filtered);
        if (refresh) {
            projectsManager.refreshProjectsTable();
        }
        return filtered;
    }

    protected abstract void runSpecificFilter(List<ProjectsManagerData> var1, List<ProjectsManagerData> var2);

    public abstract void emptyFilterData();

    public abstract void addListener(KeyListener var1);

    protected Pattern convertToPattern(JTextField field) {
        String text = field.getText().trim();
        Pattern patt = null;
        text = text.isEmpty() ? ".*" : String.valueOf(text.replace("*", ".*")) + ".*";
        try {
            patt = Pattern.compile(text);
        }
        catch (PatternSyntaxException e) {
            StandardDialogs.showErrorDialog((Component)this.getParent(), (String)this.getString("AbstractProjectFilter.error.title"), (String)("<<" + this.getString("AbstractProjectFilter.error.message") + "\"" + text + "\">>"));
        }
        return patt;
    }
}

