/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectHistoryBlock;
import csbase.client.applications.projectsmanager.models.ProjectHistoryBlockType;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.CommonClientProject;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.util.ArrayList;
import java.util.List;

public class AddPersonalCommentTask
extends ProjectsManagerTask<List<ProjectsManagerData>> {
    private List<ProjectsManagerData> projects;
    private String personalComment;

    public AddPersonalCommentTask(ProjectsManager projectsManager, List<ProjectsManagerData> projects, String personalComment) {
        super(projectsManager);
        this.projects = projects;
        this.personalComment = personalComment;
    }

    protected void performTask() throws Exception {
        ArrayList<ProjectsManagerData> list = new ArrayList<ProjectsManagerData>();
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        int i = 0;
        while (i < this.projects.size()) {
            CommonClientProject ccp = psi.openProject(this.projects.get(i).getProjectId(), false);
            ProjectHistoryBlock phb = new ProjectHistoryBlock(ProjectHistoryBlockType.PERSONAL_TEXT);
            phb.setUserComment("\n" + this.personalComment);
            try {
                ccp.getRoot().appendDescription(phb.getHistoryBlock());
            }
            catch (Exception e) {
                list.add(this.projects.get(i));
            }
            ++i;
        }
        this.setResult(list);
    }
}

