/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.DiskUsageServiceInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class MultipleProjectSpaceTask
extends ProjectsManagerTask<List<Double>> {
    private final List<String> projectsNames;
    private final List<Object> ownersIds;

    public MultipleProjectSpaceTask(ProjectsManager projectsManager, List<String> projectsNames, List<Object> ownersIds) {
        super(projectsManager);
        this.projectsNames = projectsNames;
        this.ownersIds = ownersIds;
    }

    protected void performTask() throws Exception {
        List<Double> projectsSpace = this.getProjectsSpace();
        this.setResult(projectsSpace);
    }

    private List<Double> getProjectsSpace() throws RemoteException {
        ArrayList<Double> projectsOccupiedSpace = new ArrayList<Double>();
        DiskUsageServiceInterface dus = ClientRemoteLocator.diskUsageService;
        int i = 0;
        while (i < this.projectsNames.size()) {
            double usedSpaceForProjectMb = dus.getUsedSpaceForProjectMb(this.ownersIds.get(i), this.projectsNames.get(i));
            projectsOccupiedSpace.add(usedSpaceForProjectMb);
            ++i;
        }
        return projectsOccupiedSpace;
    }
}

