/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsynchronization;

import csbase.client.applications.projectsynchronization.ProjectSynchronization;
import csbase.client.applications.projectsynchronization.ProjectSynchronizationRemoteTask;
import csbase.remote.ProjectSynchronizationMonitor;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.MessageFormat;
import javax.swing.JEditorPane;

public class ProjectSynchronizationWizardMonitor
extends UnicastRemoteObject
implements ProjectSynchronizationMonitor {
    private JEditorPane textArea;
    private StringBuffer text;
    private ProjectSynchronization application;
    private boolean cancelled = false;

    protected ProjectSynchronizationWizardMonitor(JEditorPane textArea, StringBuffer text, ProjectSynchronization application) throws RemoteException {
        this.application = application;
        this.text = text;
        this.textArea = textArea;
        this.text.append(application.getString("ProjectSynchronizationWizardMonitor.result.head"));
        this.text.append("<BR><BR>");
        this.textArea.setText(text.toString());
    }

    public void partialResult(String[] file, String result) throws RemoteException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < file.length) {
            sb.append(file[i]);
            if (i < file.length - 1) {
                sb.append("/");
            }
            ++i;
        }
        String msg = result == null ? MessageFormat.format(this.application.getString("msg.transfer"), sb.toString()) : MessageFormat.format(this.application.getString("msg.transfer.error"), sb.toString(), result);
        this.text.append(msg);
        this.text.append("<BR>");
    }

    public void finalResult(String result) throws RemoteException {
        if (result != null) {
            this.text.append("<BR><HR><BR>");
            this.text.append(result);
            this.text.append("<BR></BODY></HTML>");
            this.textArea.setText(this.text.toString());
        } else {
            this.textArea.setText(this.text.toString());
        }
    }

    public boolean isCancelled() throws RemoteException {
        return this.cancelled;
    }

    public void setCancelled() {
        this.text.append("<BR><HR><BR>");
        this.text.append(this.application.getString("canceling"));
        String newText = String.valueOf(this.text.toString()) + "<BR></BODY></HTML>";
        this.textArea.setText(newText);
        this.cancelled = true;
    }

    public void initTransfer(String file) throws RemoteException {
        ProjectSynchronizationRemoteTask task = this.application.getTask();
        if (task != null) {
            task.setStepText(file);
        }
    }
}

